/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.tech.math.fractal;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.math.main.Calculator;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.core.programcontrol.future.AbstractFuture;
import ch.nolix.core.programcontrol.jobpool.JobPool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.programcontrol.future.IFuture;
import ch.nolix.coreapi.programcontrol.process.FinishRequestable;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.graphic.image.MutableImage;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.tech.math.bigdecimalmath.ComplexNumber;
import ch.nolix.tech.math.fractal.Fractal;
import ch.nolix.tech.math.fractal.FractalTool;
import ch.nolix.techapi.math.bigdecimalmath.IComplexNumber;
import ch.nolix.techapi.math.fractal.IFractal;
import ch.nolix.techapi.math.fractal.IFractalTool;
import ch.nolix.techapi.math.fractal.IImageGenerator;
import java.math.BigDecimal;
import java.util.Optional;

public final class ImageGenerator
extends AbstractFuture
implements IImageGenerator {
    private static final int IMAGE_ROWS_PER_THREAD = 10;
    private static final IFractalTool FRACTAL_TOOL = new FractalTool();
    private final IFractal fractal;
    private final BigDecimal squaredMinMagnitudeForDivergence;
    private final MutableImage image;
    private final IContainer<IFuture> futures;

    private ImageGenerator(IFractal fractal) {
        Validator.assertThat(fractal).thatIsNamed(Fractal.class).isNotNull();
        this.fractal = fractal;
        this.squaredMinMagnitudeForDivergence = FRACTAL_TOOL.getSquaredMinMagnitudeForDivergence(fractal);
        this.image = MutableImage.withWidthAndHeightAndColor(fractal.getWidthInPixel(), fractal.getHeightInPixel(), X11ColorCatalog.WHITE);
        this.futures = this.startFillImageAndGetFutures();
    }

    public static ImageGenerator forFractal(IFractal fractal) {
        return new ImageGenerator(fractal);
    }

    @Override
    public boolean caughtError() {
        return this.futures.containsAny(IFuture::caughtError);
    }

    @Override
    public Throwable getError() {
        Optional<IFuture> futureWithError = this.futures.getOptionalStoredFirst(IFuture::caughtError);
        if (futureWithError.isEmpty()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "error");
        }
        return futureWithError.get().getError();
    }

    public MutableImage getStoredImage() {
        return this.image;
    }

    @Override
    public boolean isFinished() {
        return this.futures.containsOnly(FinishRequestable::isFinished);
    }

    @Override
    public void waitUntilIsFinished() {
        this.futures.forEach(IFuture::waitUntilIsFinished);
    }

    @Override
    public void waitUntilIsFinished(int timeoutInMilliseconds) {
        long startTimeInMilliseconds = System.currentTimeMillis();
        FlowController.waitAsLongAs(() -> System.currentTimeMillis() - startTimeInMilliseconds < (long)timeoutInMilliseconds && this.isRunning());
        if (!this.isFinished()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "reached timeout before having finished");
        }
    }

    private void fillImageRow(int y) {
        int x = 1;
        while (x <= this.image.getWidth()) {
            this.fillImagePixel(x, y);
            ++x;
        }
    }

    private void fillImageRows(int startImageRow, int endImageRow) {
        int y = startImageRow;
        while (y <= endImageRow) {
            this.fillImageRow(y);
            ++y;
        }
    }

    private void fillImagePixel(int x, int y) {
        Color color = Color.createAverageFrom(this.getColorOfPixel((double)x - 0.75, (double)y - 0.75), this.getColorOfPixel((double)x - 0.75, (double)y - 0.25), this.getColorOfPixel((double)x - 0.25, (double)y - 0.75), this.getColorOfPixel((double)x - 0.25, (double)y - 0.25));
        this.image.setPixel(x, y, color);
    }

    private IColor getColorOfPixel(double x, double y) {
        IComplexNumber z = this.getComplexNumberOfPixel(x, y);
        int iterationCount = this.getIterationCountForComplexNumberUntilValueSquaredMagnitudeExceedsLimitOrMinusOne(z);
        return this.fractal.getColorForIterationCountWhereValueMagnitudeExceedsMaxMagnitude(iterationCount);
    }

    private IComplexNumber getComplexNumberOfPixel(double x, double y) {
        return new ComplexNumber(FRACTAL_TOOL.getMinX(this.fractal).add(FRACTAL_TOOL.getUnitsForHorizontalPixelCount(this.fractal, x)), FRACTAL_TOOL.getMinY(this.fractal).add(FRACTAL_TOOL.getUnitsForVerticalPixelCount(this.fractal, y)));
    }

    private int getIterationCountForComplexNumberUntilValueSquaredMagnitudeExceedsLimitOrMinusOne(IComplexNumber complexNumber) {
        return FRACTAL_TOOL.getIterationCountForStartNumberWhereSquaredMagnitudeOfValueExceedsLimitOrMinusOne(this.fractal, complexNumber, this.squaredMinMagnitudeForDivergence);
    }

    private ILinkedList<IFuture> startFillImageAndGetFutures() {
        LinkedList<IFuture> lFutures = LinkedList.createEmpty();
        JobPool jobPool = new JobPool();
        int heightInpixel = this.fractal.getHeightInPixel();
        int y = 1;
        while (y < heightInpixel) {
            int startImageRow = y;
            int endImageRow = Calculator.getMin(heightInpixel, y + 10 - 1);
            lFutures.addAtEnd(jobPool.enqueue(() -> this.fillImageRows(startImageRow, endImageRow)));
            y += 10;
        }
        return lFutures;
    }
}

