/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.tech.math.fractal;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.graphic.image.MutableImage;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.tech.math.fractal.ImageGenerator;
import ch.nolix.techapi.math.bigdecimalmath.IClosedInterval;
import ch.nolix.techapi.math.bigdecimalmath.IComplexNumber;
import ch.nolix.techapi.math.bigdecimalmath.ISequence;
import ch.nolix.techapi.math.fractal.IFractal;
import java.math.BigDecimal;
import java.util.function.Function;
import java.util.function.IntFunction;

public final class Fractal
implements IFractal {
    public static final Color CONVERGENCE_COLOR = X11ColorCatalog.BLACK;
    private final IClosedInterval realComponentInterval;
    private final IClosedInterval imaginaryComponentInterval;
    private final int widthInPixel;
    private final int heightInPixel;
    private final Function<IComplexNumber, ISequence<IComplexNumber>> sequenceCreator;
    private final BigDecimal sequencesMinDivergenceMagnitude;
    private final int sequencesMaxIterationCount;
    private final IntFunction<IColor> colorFunction;
    private final int decimalPlaces;

    public Fractal(IClosedInterval realComponentInterval, IClosedInterval imaginaryComponentInterval, int widthInPixel, int heightInPixel, Function<IComplexNumber, ISequence<IComplexNumber>> sequenceCreator, BigDecimal sequencesMinDivergenceMagnitude, int sequencesMaxIterationCount, IntFunction<IColor> colorFunction, int decimalPlaces) {
        Validator.assertThat(realComponentInterval).thatIsNamed("real component interval").isNotNull();
        Validator.assertThat(imaginaryComponentInterval).thatIsNamed("imaginary component interval").isNotNull();
        Validator.assertThat(widthInPixel).thatIsNamed("width in pixel").isPositive();
        Validator.assertThat(heightInPixel).thatIsNamed("height in pixel").isPositive();
        Validator.assertThat(sequenceCreator).thatIsNamed("sequence creator").isNotNull();
        Validator.assertThat(sequencesMinDivergenceMagnitude).thatIsNamed("sequences min divergence magnitude").isPositive();
        Validator.assertThat(sequencesMaxIterationCount).thatIsNamed("sequences max iteration count").isPositive();
        Validator.assertThat(colorFunction).thatIsNamed("color function").isNotNull();
        Validator.assertThat(decimalPlaces).thatIsNamed("big decimal scale").isPositive();
        this.imaginaryComponentInterval = imaginaryComponentInterval.inDecimalPlaces(decimalPlaces);
        this.realComponentInterval = realComponentInterval.inDecimalPlaces(decimalPlaces);
        this.widthInPixel = widthInPixel;
        this.heightInPixel = heightInPixel;
        this.sequenceCreator = sequenceCreator;
        this.sequencesMinDivergenceMagnitude = sequencesMinDivergenceMagnitude.setScale(decimalPlaces);
        this.sequencesMaxIterationCount = sequencesMaxIterationCount;
        this.colorFunction = colorFunction;
        this.decimalPlaces = decimalPlaces;
    }

    @Override
    public ISequence<IComplexNumber> createSequenceFor(IComplexNumber complexNumber) {
        return this.sequenceCreator.apply(complexNumber);
    }

    @Override
    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    @Override
    public IColor getColorForIterationCountWhereValueMagnitudeExceedsMaxMagnitude(int iterationCount) {
        if (iterationCount == -1) {
            return CONVERGENCE_COLOR;
        }
        return this.colorFunction.apply(iterationCount);
    }

    @Override
    public int getHeightInPixel() {
        return this.heightInPixel;
    }

    @Override
    public IClosedInterval getImaginaryComponentInterval() {
        return this.imaginaryComponentInterval;
    }

    @Override
    public IClosedInterval getRealComponentInterval() {
        return this.realComponentInterval;
    }

    @Override
    public int getMaxIterationCount() {
        return this.sequencesMaxIterationCount;
    }

    @Override
    public BigDecimal getMinMagnitudeForDivergence() {
        return this.sequencesMinDivergenceMagnitude;
    }

    @Override
    public int getWidthInPixel() {
        return this.widthInPixel;
    }

    @Override
    public ImageGenerator startImageGeneration() {
        return ImageGenerator.forFractal(this);
    }

    public MutableImage toImage() {
        ImageGenerator imageBuilder = this.startImageGeneration();
        imageBuilder.waitUntilIsFinishedSuccessfully();
        return imageBuilder.getStoredImage();
    }
}

