/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.tech.math.bigdecimalmath;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.tech.math.bigdecimalmath.AbstractSequence;
import ch.nolix.techapi.math.bigdecimalmath.IComplexNumber;
import ch.nolix.techapi.math.bigdecimalmath.ISequenceDefinedBy2Predecessor;
import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;

public final class ComplexSequenceDefinedBy2Predecessor
extends AbstractSequence<IComplexNumber>
implements ISequenceDefinedBy2Predecessor<IComplexNumber> {
    private final IComplexNumber firstValue;
    private final IComplexNumber secondValue;
    private final BiFunction<IComplexNumber, IComplexNumber, IComplexNumber> nextValueFunction;

    public ComplexSequenceDefinedBy2Predecessor(IComplexNumber firstValue, IComplexNumber secondValue, BinaryOperator<IComplexNumber> nextValueFunction) {
        Validator.assertThat(firstValue).thatIsNamed("first value").isNotNull();
        Validator.assertThat(secondValue).thatIsNamed("second value").isNotNull();
        Validator.assertThat(nextValueFunction).thatIsNamed("next value function").isNotNull();
        this.firstValue = firstValue;
        this.secondValue = secondValue;
        this.nextValueFunction = nextValueFunction;
    }

    @Override
    public IComplexNumber getFirstValue() {
        return this.firstValue;
    }

    @Override
    public IComplexNumber getSecondValue() {
        return this.secondValue;
    }

    @Override
    protected BigDecimal calculateSquaredMagnitudeForValue(IComplexNumber value) {
        return value.getSquaredMagnitude();
    }

    @Override
    protected IComplexNumber calculateValue(int index) {
        if (index == 1) {
            return this.getFirstValue();
        }
        if (index == 2) {
            return this.getSecondValue();
        }
        return this.nextValueFunction.apply((IComplexNumber)this.getValueAtOneBasedIndex(index - 2), (IComplexNumber)this.getValueAtOneBasedIndex(index - 1));
    }
}

