/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.tech.math.bigdecimalmath;

import ch.nolix.core.datastructure.pair.Pair;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.math.main.Calculator;
import ch.nolix.techapi.math.bigdecimalmath.IClosedInterval;
import java.math.BigDecimal;
import java.math.RoundingMode;

public final class ClosedInterval
implements IClosedInterval {
    private final BigDecimal min;
    private final BigDecimal max;

    public ClosedInterval(BigDecimal min, BigDecimal max) {
        Validator.assertThat(min).thatIsNamed("minimum").isNotNull();
        Validator.assertThat(max).thatIsNamed("maximum").isNotSmallerThan(min);
        int decimalPlaces = Calculator.getMax(min.scale(), max.scale());
        this.min = min.setScale(decimalPlaces, RoundingMode.HALF_UP);
        this.max = max.setScale(decimalPlaces, RoundingMode.HALF_UP);
    }

    public ClosedInterval(BigDecimal min, BigDecimal max, int decimalPlaces) {
        Validator.assertThat(min).thatIsNamed("minimum").isNotNull();
        Validator.assertThat(max).thatIsNamed("maximum").isNotSmallerThan(min);
        Validator.assertThat(decimalPlaces).thatIsNamed("big decimal scale").isPositive();
        this.min = min.setScale(decimalPlaces, RoundingMode.HALF_UP);
        this.max = max.setScale(decimalPlaces, RoundingMode.HALF_UP);
    }

    public ClosedInterval(double min, double max) {
        this(BigDecimal.valueOf(min), BigDecimal.valueOf(max));
    }

    public ClosedInterval(double min, double max, int decimalPlaces) {
        this(BigDecimal.valueOf(min), BigDecimal.valueOf(max), decimalPlaces);
    }

    @Override
    public boolean containsValue(BigDecimal value) {
        return value != null && value.compareTo(this.min) >= 0 && value.compareTo(this.max) <= 0;
    }

    public boolean equals(Object object) {
        IClosedInterval closedInterval;
        return object instanceof IClosedInterval && this.equalsClosedIntervall(closedInterval = (IClosedInterval)object);
    }

    @Override
    public int getDecimalPlaces() {
        return this.min.scale();
    }

    public Pair<IClosedInterval, IClosedInterval> getHalfs() {
        int decimalPlaces = this.getDecimalPlaces();
        BigDecimal midPoint = this.getMidPoint();
        return new Pair<IClosedInterval, IClosedInterval>(new ClosedInterval(this.min, midPoint, decimalPlaces), new ClosedInterval(midPoint, this.max, decimalPlaces));
    }

    @Override
    public BigDecimal getLength() {
        return this.max.subtract(this.min);
    }

    @Override
    public BigDecimal getMax() {
        return this.max;
    }

    @Override
    public BigDecimal getMidPoint() {
        return this.min.add(this.max).divide(BigDecimal.valueOf(2.0)).setScale(this.min.scale());
    }

    @Override
    public BigDecimal getMin() {
        return this.min;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public ClosedInterval inDecimalPlaces(int decimalPlaces) {
        return new ClosedInterval(this.min, this.max, decimalPlaces);
    }

    @Override
    public boolean intersectsWith(IClosedInterval closedInterval) {
        return this.getMin().compareTo(closedInterval.getMax()) < 0 && this.getMax().compareTo(closedInterval.getMin()) > 0;
    }

    public String toString() {
        return "[" + String.valueOf(this.min) + ", " + String.valueOf(this.max) + "]";
    }

    private boolean equalsClosedIntervall(IClosedInterval closedInterval) {
        return closedInterval != null && this.min.equals(closedInterval.getMin()) && this.max.equals(closedInterval.getMax());
    }
}

