/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.main;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.ILayer;

final class ControlParent {
    private final ILayer<?> layer;
    private final IControl<?, ?> control;

    private ControlParent(IControl<?, ?> control) {
        Validator.assertThat(control).thatIsNamed(IControl.class).isNotNull();
        this.layer = null;
        this.control = control;
    }

    private ControlParent(ILayer<?> layer) {
        Validator.assertThat(layer).thatIsNamed(ILayer.class).isNotNull();
        this.layer = layer;
        this.control = null;
    }

    public static ControlParent forControl(IControl<?, ?> control) {
        return new ControlParent(control);
    }

    public static ControlParent forLayer(ILayer<?> layer) {
        return new ControlParent(layer);
    }

    public static ControlParent withLayer(ILayer<?> layer) {
        return new ControlParent(layer);
    }

    public boolean belongsToGui() {
        if (this.isControl()) {
            return this.control.belongsToGui();
        }
        return this.layer.belongsToGui();
    }

    public boolean belongsToLayer() {
        if (this.isControl()) {
            return this.control.belongsToLayer();
        }
        return true;
    }

    public IControl<?, ?> getStoredControl() {
        this.assertIsControl();
        return this.control;
    }

    public Object getStoredElement() {
        if (this.isControl()) {
            return this.control;
        }
        return this.layer;
    }

    public ILayer<?> getStoredRootLayer() {
        if (this.isLayer()) {
            return this.layer;
        }
        return this.control.getStoredParentLayer();
    }

    public boolean isControl() {
        return this.control != null;
    }

    public boolean isLayer() {
        return this.layer != null;
    }

    private void assertIsControl() {
        if (!this.isControl()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not a Control");
        }
    }
}

