/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webcontainercontrol.grid;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.web.htmlelementmodel.HtmlElement;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;
import ch.nolix.systemapi.webcontainercontrol.grid.IGrid;
import ch.nolix.systemapi.webgui.main.IControl;

public final class GridHtmlBuilderHelper {
    private GridHtmlBuilderHelper() {
    }

    public static HtmlElement createHtmlElementForTableOfGrid(IGrid control) {
        String type = "table";
        HtmlElement childElement = GridHtmlBuilderHelper.createHtmlElementForTableBodyOfGrid(control);
        return HtmlElement.withTypeAndChildElement("table", childElement);
    }

    public static HtmlElement createHtmlElementForTableBodyOfGrid(IGrid grid) {
        String type = "tbody";
        IContainer<IHtmlElement> childElement = GridHtmlBuilderHelper.createHtmlElementsForChildControlsOfGrid(grid);
        return HtmlElement.withTypeAndChildElements("tbody", childElement);
    }

    private static IContainer<IHtmlElement> createHtmlElementsForChildControlsOfGrid(IGrid grid) {
        LinkedList<IHtmlElement> htmlElements = LinkedList.createEmpty();
        int rowCount = grid.getRowCount();
        int r = 1;
        while (r <= rowCount) {
            htmlElements.addAtEnd(GridHtmlBuilderHelper.createHtmlElementForRowOfGrid(grid, r));
            ++r;
        }
        return htmlElements;
    }

    private static HtmlElement createHtmlElementForRowOfGrid(IGrid grid, int rowIndex) {
        String type = "tr";
        IContainer<IHtmlElement> childElements = GridHtmlBuilderHelper.createHtmlElementsForCellsOfRowOfGrid(grid, rowIndex);
        return HtmlElement.withTypeAndChildElements("tr", childElements);
    }

    private static IContainer<IHtmlElement> createHtmlElementsForCellsOfRowOfGrid(IGrid grid, int rowIndex) {
        LinkedList<IHtmlElement> htmlElements = LinkedList.createEmpty();
        int columnCount = grid.getColumnCount();
        int c = 1;
        while (c <= columnCount) {
            htmlElements.addAtEnd(GridHtmlBuilderHelper.createHtmlElementForCellOfGrid(grid, rowIndex, c));
            ++c;
        }
        return htmlElements;
    }

    private static HtmlElement createHtmlElementForCellOfGrid(IGrid grid, int rowIndex, int columnIndex) {
        String type = "td";
        if (grid.containsControlAtOneBasedRowAndColumnIndex(rowIndex, columnIndex)) {
            IControl<?, ?> childControl = grid.getStoredChildControlAtOneBasedRowAndColumnIndex(rowIndex, columnIndex);
            IHtmlElement childElement = childControl.getHtml();
            return HtmlElement.withTypeAndChildElement("td", childElement);
        }
        return HtmlElement.withType("td");
    }
}

