/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webcontainercontrol.grid;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.web.cssmodel.CssProperty;
import ch.nolix.core.web.cssmodel.CssRule;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.coreapi.web.cssmodel.ICssRule;
import ch.nolix.system.webgui.controltool.AbstractControlCssBuilder;
import ch.nolix.system.webgui.controltool.CssValueMapper;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.webcontainercontrol.grid.IGrid;
import ch.nolix.systemapi.webcontainercontrol.grid.IGridStyle;
import ch.nolix.systemapi.webgui.main.ControlState;

public final class GridCssBuilder
extends AbstractControlCssBuilder<IGrid, IGridStyle> {
    @Override
    protected void fillUpCssPropertiesForControlAndAllStatesIntoList(IGrid control, ILinkedList<ICssProperty> list) {
    }

    @Override
    protected void fillUpCssPropertiesForControlAndStateIntoList(IGrid control, ControlState state, ILinkedList<ICssProperty> list) {
    }

    @Override
    protected void fillUpAdditionalCssRulesForControlAndStateIntoList(IGrid control, ControlState state, ILinkedList<? super ICssRule> list) {
        IGridStyle style = (IGridStyle)control.getStoredStyle();
        int gridThickness = style.getGridThicknessWhenHasState(state);
        IColor gridcolor = style.getGridColorWhenHasState(state);
        int childControlMargin = style.getChildControlMarginWhenHasState(state);
        list.addAtEnd(CssRule.withSelectorAndProperties("table, th, td", ImmutableList.withElements(CssProperty.withNameAndValue("border-collapse", "collapse"), CssProperty.withNameAndValue("border", "solid " + gridThickness + "px"), CssProperty.withNameAndValue("border-color", CssValueMapper.mapColorToCssValue(gridcolor)))));
        list.addAtEnd(CssRule.withSelectorAndProperties("td", ImmutableList.withElements(CssProperty.withNameAndValue("padding", childControlMargin + "px"))));
    }

    @Override
    protected void fillUpAdditionalCssRulesForControlAndAllStatesIntoList(IGrid control, ILinkedList<? super ICssRule> list) {
    }
}

