/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webcontainercontrol.grid;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.state.statemutation.Clearable;
import ch.nolix.system.element.mutableelement.AbstractMutableElement;
import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.system.element.property.Value;
import ch.nolix.system.webgui.main.ControlFactory;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.webgui.main.IControl;

public final class GridCell
extends AbstractMutableElement
implements Clearable {
    private static final String ROW_INDEX_HEADER = "RowIndex";
    private static final String COLUMN_INDEX_HEADER = "ColumnIndex";
    private static final String CONTROL_HEADER = "Control";
    private final Value<Integer> rowIndex = Value.forInt("RowIndex", this::setRowIndex);
    private final Value<Integer> columnIndex = Value.forInt("ColumnIndex", this::setColumnIndex);
    private final MutableOptionalValue<IControl<?, ?>> control = new MutableOptionalValue<IControl>("Control", this::setControl, ControlFactory::createControlFromSpecification, IElement::getSpecification);

    private GridCell() {
    }

    public static GridCell fromSpecification(INode<?> specification) {
        GridCell cell = new GridCell();
        cell.resetFromSpecification(specification);
        return cell;
    }

    public static GridCell withOneBasedRowIndexAndColumnIndex(int rowIndex, int columnIndex) {
        GridCell cell = new GridCell();
        cell.setRowIndex(rowIndex);
        cell.setColumnIndex(columnIndex);
        return cell;
    }

    @Override
    public void clear() {
        this.control.clear();
    }

    public int getColumnIndex() {
        return (Integer)this.columnIndex.getValue();
    }

    public IControl<?, ?> getStoredControl() {
        return (IControl)this.control.getValue();
    }

    public int getRowIndex() {
        return (Integer)this.rowIndex.getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.control.isEmpty();
    }

    @Override
    public void reset() {
        this.clear();
    }

    public void setControl(IControl<?, ?> control) {
        this.control.setValue(control);
    }

    private void setColumnIndex(int columnIndex) {
        Validator.assertThat(columnIndex).thatIsNamed("column index").isPositive();
        this.columnIndex.setValue(columnIndex);
    }

    private void setRowIndex(int rowIndex) {
        Validator.assertThat(rowIndex).thatIsNamed("row index").isPositive();
        this.rowIndex.setValue(rowIndex);
    }
}

