/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webatomiccontrol.validationlabel;

import ch.nolix.coreapi.state.statemutation.Clearable;
import ch.nolix.systemapi.webatomiccontrol.validationlabel.IValidationLabel;
import ch.nolix.systemapi.webatomiccontrol.validationlabel.IValidationLabelTool;
import ch.nolix.systemapi.webgui.main.IControl;
import java.util.Optional;
import java.util.function.Consumer;

public final class ValidationLabelTool
implements IValidationLabelTool {
    @Override
    public void clearNearestValidationLabelOfControl(IControl<?, ?> control) {
        Optional<IValidationLabel> validationLabel = this.getOptionalStoredNearestValidationLabelOfControl(control);
        validationLabel.ifPresent(Clearable::clear);
    }

    @Override
    public void executeActionOfControlAndShowProbableErrorInNearestValidationLabel(IControl<?, ?> control, Runnable action) {
        try {
            action.run();
            this.clearNearestValidationLabelOfControl(control);
        }
        catch (Throwable error) {
            this.showErrorInNearestValidationLabelOfControlOrSwallowError(control, error);
        }
    }

    @Override
    public <C extends IControl<C, ?>> void executeActionOfControlAndShowProbableErrorInNearestValidationLabel(C control, Consumer<? super C> action) {
        try {
            action.accept(control);
            this.clearNearestValidationLabelOfControl(control);
        }
        catch (Throwable error) {
            this.showErrorInNearestValidationLabelOfControlOrSwallowError(control, error);
        }
    }

    @Override
    public Optional<IValidationLabel> getOptionalStoredNearestValidationLabelOfControl(IControl<?, ?> control) {
        if (control.belongsToControl()) {
            IControl<?, ?> parentControl = control.getStoredParentControl();
            for (IControl iControl : parentControl.getStoredChildControls()) {
                if (!(iControl instanceof IValidationLabel)) continue;
                IValidationLabel validationLabel = (IValidationLabel)iControl;
                return Optional.of(validationLabel);
            }
            return this.getOptionalStoredNearestValidationLabelOfControl(parentControl);
        }
        return Optional.empty();
    }

    @Override
    public void showErrorInNearestValidationLabelOfControlOrSwallowError(IControl<?, ?> control, Throwable error) {
        Optional<IValidationLabel> validationLabel = this.getOptionalStoredNearestValidationLabelOfControl(control);
        validationLabel.ifPresent(l -> l.showError(error));
    }
}

