/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webatomiccontrol.link;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.web.url.UrlTool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.web.htmlattribute.LinkTarget;
import ch.nolix.coreapi.web.url.IUrlTool;
import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.system.element.property.MutableValue;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.webatomiccontrol.link.LinkCssBuilder;
import ch.nolix.system.webatomiccontrol.link.LinkHtmlBuilder;
import ch.nolix.system.webatomiccontrol.link.LinkStyle;
import ch.nolix.system.webgui.main.Control;
import ch.nolix.systemapi.gui.font.LineDecoration;
import ch.nolix.systemapi.gui.model.CursorIcon;
import ch.nolix.systemapi.webatomiccontrol.link.ILink;
import ch.nolix.systemapi.webatomiccontrol.link.ILinkStyle;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.ControlState;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import java.util.Optional;

public final class Link
extends Control<ILink, ILinkStyle>
implements ILink {
    public static final String DEFAULT_DISPLAY_TEXT = "?";
    private static final LinkTarget DEFAULT_TARGET = LinkTarget.NEW_TAB;
    private static final String DISPLAY_TEXT_HEADER = "DisplayText";
    private static final String TARGET_HEADER = "Target";
    private static final String URL_HEADER = "Url";
    private static final LinkHtmlBuilder LINK_HTML_BUILDER = new LinkHtmlBuilder();
    private static final LinkCssBuilder LINK_CSS_BUILDER = new LinkCssBuilder();
    private static final IUrlTool URL_TOOL = new UrlTool();
    private final MutableValue<String> displayText = MutableValue.forString("DisplayText", "?", this::setDisplayText);
    private final MutableValue<LinkTarget> target = new MutableValue<LinkTarget>("Target", DEFAULT_TARGET, this::setTarget, s -> LinkTarget.valueOf(s.getSingleChildNodeHeader()), Node::fromEnum);
    private final MutableOptionalValue<String> url = MutableOptionalValue.forString("Url", this::setUrl);

    public Link() {
        this.reset();
        ((ILinkStyle)((ILinkStyle)this.getStoredStyle()).forStateSetTextLineDecoration(ControlState.HOVER, LineDecoration.UNDERLINE)).forStateSetTextColor(ControlState.BASE, X11ColorCatalog.BLUE);
    }

    @Override
    public String getDisplayText() {
        return (String)this.displayText.getValue();
    }

    @Override
    public Optional<String> getOptionalJavaScriptUserInputFunction() {
        return Optional.empty();
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredChildControls() {
        return ImmutableList.createEmpty();
    }

    @Override
    public LinkTarget getTarget() {
        return (LinkTarget)((Object)this.target.getValue());
    }

    @Override
    public String getUrl() {
        return (String)this.url.getValue();
    }

    @Override
    public String getUserInput() {
        return "";
    }

    @Override
    public boolean hasRole(String role) {
        return false;
    }

    @Override
    public boolean hasUrl() {
        return this.url.containsAny();
    }

    @Override
    public void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> list) {
    }

    @Override
    public void removeUrl() {
        this.url.clear();
    }

    @Override
    public void runHtmlEvent(String htmlEvent) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "runHtmlEvent");
    }

    @Override
    public ILink setDisplayText(String displayText) {
        Validator.assertThat(displayText).thatIsNamed("dipslay text").isNotBlank();
        this.displayText.setValue(displayText);
        return this;
    }

    @Override
    public ILink setTarget(LinkTarget target) {
        this.target.setValue(target);
        return this;
    }

    @Override
    public ILink setUrl(String url) {
        Validator.assertThat(url).thatIsNamed("url").isNotBlank();
        this.url.setValue(url);
        return this;
    }

    @Override
    public ILink setUrlAndDisplayTextFromIt(String url) {
        String localDisplayText = URL_TOOL.getDisplayTextForUrl(url);
        this.setUrl(url);
        this.setDisplayText(localDisplayText);
        return this;
    }

    @Override
    public ILink setUserInput(String userInput) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "setUserInput");
    }

    @Override
    protected ILinkStyle createStyle() {
        return new LinkStyle();
    }

    @Override
    protected IControlCssBuilder<ILink, ILinkStyle> getCssBuilder() {
        return LINK_CSS_BUILDER;
    }

    @Override
    protected IControlHtmlBuilder<ILink> getHtmlBuilder() {
        return LINK_HTML_BUILDER;
    }

    @Override
    protected void resetControl() {
        this.setDisplayText(DEFAULT_DISPLAY_TEXT);
        this.removeUrl();
        this.setCursorIcon(CursorIcon.HAND);
        ((ILinkStyle)this.getStoredStyle()).forStateSetTextColor(ControlState.BASE, X11ColorCatalog.BLUE);
    }
}

