/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webatomiccontrol.button;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.system.element.property.MutableValue;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.webatomiccontrol.button.ButtonCssBuilder;
import ch.nolix.system.webatomiccontrol.button.ButtonHtmlBuilder;
import ch.nolix.system.webatomiccontrol.button.ButtonStyle;
import ch.nolix.system.webatomiccontrol.validationlabel.ValidationLabelTool;
import ch.nolix.system.webgui.main.Control;
import ch.nolix.system.webgui.main.HtmlElementEvent;
import ch.nolix.systemapi.gui.model.CursorIcon;
import ch.nolix.systemapi.webatomiccontrol.button.ButtonRole;
import ch.nolix.systemapi.webatomiccontrol.button.IButton;
import ch.nolix.systemapi.webatomiccontrol.button.IButtonStyle;
import ch.nolix.systemapi.webatomiccontrol.validationlabel.IValidationLabelTool;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.ControlState;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import java.util.Optional;
import java.util.function.Consumer;

public final class Button
extends Control<IButton, IButtonStyle>
implements IButton {
    public static final String DEFAULT_TEXT = "-";
    private static final IValidationLabelTool VALIDATION_LABEL_TOOL = new ValidationLabelTool();
    private static final ButtonHtmlBuilder HTML_BUILDER = new ButtonHtmlBuilder();
    private static final ButtonCssBuilder CSS_BUILDER = new ButtonCssBuilder();
    private final MutableOptionalValue<ButtonRole> memberRole = new MutableOptionalValue<ButtonRole>("Role", this::setRole, ButtonRole::fromSpecification, Node::fromEnum);
    private final MutableValue<String> text = MutableValue.forString("Text", "-", this::setText);
    private Consumer<IButton> leftMouseButtonPressAction;
    private Consumer<IButton> leftMouseButtonReleaseAction;

    public Button() {
        this.reset();
        this.setMinWidth(200);
        ((IButtonStyle)((IButtonStyle)((IButtonStyle)((IButtonStyle)((IButtonStyle)this.getStoredStyle()).forStateSetLeftPadding(ControlState.BASE, 20)).forStateSetRightPadding(ControlState.BASE, 20)).forStateSetBackgroundColor(ControlState.BASE, X11ColorCatalog.LIGHT_GREY)).forStateSetBackgroundColor(ControlState.HOVER, X11ColorCatalog.DARK_GREY)).forStateSetBackgroundColor(ControlState.FOCUS, X11ColorCatalog.DARK_GREY);
    }

    @Override
    public Optional<String> getOptionalJavaScriptUserInputFunction() {
        return Optional.empty();
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredChildControls() {
        return ImmutableList.createEmpty();
    }

    @Override
    public ButtonRole getRole() {
        return (ButtonRole)((Object)this.memberRole.getValue());
    }

    @Override
    public String getText() {
        return (String)this.text.getValue();
    }

    @Override
    public String getUserInput() {
        return "";
    }

    @Override
    public boolean hasRole(String role) {
        return this.hasRole() && this.getRole().toString().equals(role);
    }

    @Override
    public boolean hasRole() {
        return this.memberRole.containsAny();
    }

    @Override
    public void pressLeftMouseButton() {
        if (this.hasLeftMouseButtonPressAction()) {
            VALIDATION_LABEL_TOOL.executeActionOfControlAndShowProbableErrorInNearestValidationLabel(this, this.leftMouseButtonPressAction);
        }
    }

    @Override
    public void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> list) {
        if (this.hasLeftMouseButtonPressAction()) {
            list.addAtEnd(HtmlElementEvent.withHtmlElementIdAndHtmlEvent(this.getInternalId(), "onmousedown"));
        }
        if (this.hasLeftMouseButtonReleaseAction()) {
            list.addAtEnd(HtmlElementEvent.withHtmlElementIdAndHtmlEvent(this.getInternalId(), "onmouseup"));
        }
    }

    @Override
    public void releaseLeftMouseButton() {
        if (this.hasLeftMouseButtonReleaseAction()) {
            VALIDATION_LABEL_TOOL.executeActionOfControlAndShowProbableErrorInNearestValidationLabel(this, this.leftMouseButtonReleaseAction);
        }
    }

    @Override
    public void removeLeftMouseButtonPressAction() {
        this.leftMouseButtonPressAction = null;
    }

    @Override
    public void removeLeftMouseButtonReleaseAction() {
        this.leftMouseButtonReleaseAction = null;
    }

    @Override
    public void removeRole() {
        this.memberRole.clear();
    }

    @Override
    public void runHtmlEvent(String htmlEvent) {
        switch (htmlEvent) {
            case "onmousedown": {
                this.pressLeftMouseButton();
                break;
            }
            case "onmouseup": {
                this.releaseLeftMouseButton();
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName(htmlEvent, "HTML event");
            }
        }
    }

    @Override
    public IButton setLeftMouseButtonPressAction(Runnable leftMouseButtonPressAction) {
        Validator.assertThat(leftMouseButtonPressAction).thatIsNamed("left mouse button press action").isNotNull();
        return this.setLeftMouseButtonPressAction((IButton b) -> leftMouseButtonPressAction.run());
    }

    @Override
    public IButton setLeftMouseButtonPressAction(Consumer<IButton> leftMouseButtonPressAction) {
        Validator.assertThat(leftMouseButtonPressAction).thatIsNamed("left mouse button press action").isNotNull();
        this.leftMouseButtonPressAction = leftMouseButtonPressAction;
        return this;
    }

    @Override
    public IButton setLeftMouseButtonRelaseAction(Runnable leftMouseButtonReleaseAction) {
        Validator.assertThat(leftMouseButtonReleaseAction).thatIsNamed("left mouse button release action").isNotNull();
        return this.setLeftMouseButtonRelaseAction((IButton b) -> leftMouseButtonReleaseAction.run());
    }

    @Override
    public IButton setLeftMouseButtonRelaseAction(Consumer<IButton> leftMouseButtonReleaseAction) {
        Validator.assertThat(leftMouseButtonReleaseAction).thatIsNamed("left mouse button release action").isNotNull();
        this.leftMouseButtonReleaseAction = leftMouseButtonReleaseAction;
        return this;
    }

    @Override
    public IButton setRole(ButtonRole role) {
        this.memberRole.setValue(role);
        return this;
    }

    @Override
    public IButton setText(String text) {
        this.text.setValue(text);
        return this;
    }

    @Override
    public IButton setUserInput(String userInput) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "setUserInput");
    }

    @Override
    protected IButtonStyle createStyle() {
        return new ButtonStyle();
    }

    @Override
    protected IControlCssBuilder<IButton, IButtonStyle> getCssBuilder() {
        return CSS_BUILDER;
    }

    @Override
    protected IControlHtmlBuilder<IButton> getHtmlBuilder() {
        return HTML_BUILDER;
    }

    @Override
    protected void resetControl() {
        this.removeRole();
        this.setText(DEFAULT_TEXT);
        this.removeLeftMouseButtonPressAction();
        this.removeLeftMouseButtonReleaseAction();
        this.setCursorIcon(CursorIcon.HAND);
    }

    private boolean hasLeftMouseButtonPressAction() {
        return this.leftMouseButtonPressAction != null;
    }

    private boolean hasLeftMouseButtonReleaseAction() {
        return this.leftMouseButtonReleaseAction != null;
    }
}

