/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.counterpartupdater;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.system.webapplication.counterpartupdater.UpdateCommandCreator;
import ch.nolix.systemapi.webgui.main.IWebGui;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public final class WebClientCounterpartUpdater {
    private static final UpdateCommandCreator UPDATE_COMMAND_CREATOR = new UpdateCommandCreator();
    private final BooleanSupplier openStateRequestable;
    private final Consumer<IContainer<? extends IChainedNode>> counterpartRunner;

    private WebClientCounterpartUpdater(Consumer<IContainer<? extends IChainedNode>> counterpartRunner, BooleanSupplier openStateRequestable) {
        Validator.assertThat(openStateRequestable).thatIsNamed("open state requestable").isNotNull();
        Validator.assertThat(counterpartRunner).thatIsNamed("counterpart runner").isNotNull();
        this.openStateRequestable = openStateRequestable;
        this.counterpartRunner = counterpartRunner;
    }

    public static WebClientCounterpartUpdater forCounterpartRunnerAndOpenStateRequestable(Consumer<IContainer<? extends IChainedNode>> counterpartRunner, BooleanSupplier openStateRequester) {
        return new WebClientCounterpartUpdater(counterpartRunner, openStateRequester);
    }

    public void updateCounterpartFromWebGui(IWebGui<?> webGui) {
        webGui.applyStyleIfHasStyle();
        IContainer<IChainedNode> updateCommands = UPDATE_COMMAND_CREATOR.createUpdateCommandsForWebGui(webGui);
        if (this.openStateRequestable.getAsBoolean()) {
            this.counterpartRunner.accept(updateCommands);
        }
    }
}

