/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.counterpartupdater;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.chainednode.ChainedNode;
import ch.nolix.core.document.node.Node;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.cssmodel.ICss;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import java.util.Optional;

public final class UpdateCommandCreatorHelper {
    private UpdateCommandCreatorHelper() {
    }

    public static ChainedNode createSetCssCommandFromCss(ICss css) {
        return UpdateCommandCreatorHelper.createSetCssCommandFromCss(css.toStringWithoutEnclosingBrackets());
    }

    public static ChainedNode createSetCssCommandFromCss(String css) {
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNode("SetCSS", ChainedNode.withHeader(css)));
    }

    public static ChainedNode createSetHtmlElementCommandFromHtmlElement(String htmlElementId, IHtmlElement htmlElement) {
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNodes("SetHTMLElement", ChainedNode.withHeader(htmlElementId), ChainedNode.withHeader(htmlElement.toString())));
    }

    public static ChainedNode createSetEventFunctionsCommandFromHtmlElementEventRegistrations(IContainer<IHtmlElementEvent> htmlElementEventRegistrations) {
        IContainer<Node> eventFunctionsView = htmlElementEventRegistrations.getViewOf(e -> Node.withChildNode(Node.withHeader(e.getHtmlElementId()), Node.withHeader(e.getHtmlEvent())));
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNodesFromNodes("SetEventFunctions", eventFunctionsView));
    }

    public static ChainedNode createSetRootHtmlElementCommandFromHtmlElement(IHtmlElement htmlElement) {
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNode("SetRootHTMLElement", ChainedNode.withHeader(htmlElement.toString())));
    }

    public static ChainedNode createSetUserInputFunctionsCommandForControls(IContainer<IControl<?, ?>> controls) {
        LinkedList userInputFunctions = LinkedList.createEmpty();
        for (IControl iControl : controls) {
            Optional<String> userInputFunction = iControl.getOptionalJavaScriptUserInputFunction();
            if (!userInputFunction.isPresent()) continue;
            userInputFunctions.addAtEnd(UpdateCommandCreatorHelper.createUserInputFunctionFromControlAndString(iControl, userInputFunction.get()));
        }
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNodes("SetUserInputFunctions", userInputFunctions));
    }

    public static ChainedNode createUserInputFunctionFromControlAndString(IControl<?, ?> control, String string) {
        return ChainedNode.withChildNodesFromNodes(Node.withHeader(control.getInternalId()), Node.withHeader(string));
    }
}

