/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.counterpartupdater;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.chainednode.ChainedNode;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.web.cssmodel.ICss;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;
import ch.nolix.system.webapplication.counterpartupdater.UpdateCommandCreatorHelper;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.webapplication.counterpart.IUpdateCommandCreator;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import ch.nolix.systemapi.webgui.main.IWebGui;

public final class UpdateCommandCreator
implements IUpdateCommandCreator {
    @Override
    public IChainedNode createSetCssCommandForWebGui(IWebGui<?> webGui) {
        ICss css = webGui.getCss();
        return UpdateCommandCreatorHelper.createSetCssCommandFromCss(css);
    }

    @Override
    public IChainedNode createSetEventFunctionsCommandForWebGui(IWebGui<?> webGui) {
        IContainer<IHtmlElementEvent> htmlElementEventRegistrations = webGui.getHtmlElementEventRegistrations();
        return UpdateCommandCreatorHelper.createSetEventFunctionsCommandFromHtmlElementEventRegistrations(htmlElementEventRegistrations);
    }

    @Override
    public IChainedNode createSetIconCommandForWebGui(IWebGui<?> webGui) {
        return this.createSetIconCommandForIcon(webGui.getIcon());
    }

    @Override
    public IChainedNode createSetIconCommandForIcon(IImage icon) {
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNode("SetIcon", icon.getSpecification()));
    }

    @Override
    public IChainedNode createSetRootHtmlElementCommandForControl(IControl<?, ?> control) {
        String htmlElementId = control.getInternalId();
        IHtmlElement htmlElement = control.getHtml();
        return UpdateCommandCreatorHelper.createSetHtmlElementCommandFromHtmlElement(htmlElementId, htmlElement);
    }

    @Override
    public IChainedNode createSetRootHtmlElementCommandForWebGui(IWebGui<?> webGui) {
        IHtmlElement htmlElement = webGui.getHtml();
        return UpdateCommandCreatorHelper.createSetRootHtmlElementCommandFromHtmlElement(htmlElement);
    }

    @Override
    public IChainedNode createSetTitleCommandForWebGui(IWebGui<?> webGui) {
        return this.createSetTitleCommandForTitle(webGui.getTitle());
    }

    @Override
    public IChainedNode createSetTitleCommandForTitle(String title) {
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNodesFromNodes("SetTitle", Node.withHeader(title), new INode[0]));
    }

    @Override
    public IChainedNode createSetUserInputFunctionsCommandForWebGui(IWebGui<?> webGui) {
        return UpdateCommandCreatorHelper.createSetUserInputFunctionsCommandForControls(webGui.getStoredControls());
    }

    @Override
    public IContainer<IChainedNode> createUpdateCommandsForControls(IContainer<IControl<?, ?>> controls, boolean updateConstellationOrStyle) {
        Validator.assertThat(controls).thatIsNamed("controls").isNotEmpty();
        IWebGui<?> webGui = ((IControl)controls.getStoredFirst()).getStoredParentGui();
        LinkedList<IChainedNode> updatedCommands = LinkedList.createEmpty();
        updatedCommands.addAtEnd(controls.getViewOf(this::createSetRootHtmlElementCommandForControl));
        if (updateConstellationOrStyle) {
            updatedCommands.addAtEnd(this.createSetCssCommandForWebGui(webGui), (IChainedNode[])new IChainedNode[]{this.createSetEventFunctionsCommandForWebGui(webGui), this.createSetUserInputFunctionsCommandForWebGui(webGui)});
        }
        return updatedCommands;
    }

    @Override
    public IContainer<IChainedNode> createUpdateCommandsForWebGui(IWebGui<?> webGui) {
        return ImmutableList.withElements(this.createSetTitleCommandForWebGui(webGui), this.createSetIconCommandForWebGui(webGui), this.createSetRootHtmlElementCommandForWebGui(webGui), this.createSetCssCommandForWebGui(webGui), this.createSetEventFunctionsCommandForWebGui(webGui), this.createSetUserInputFunctionsCommandForWebGui(webGui));
    }
}

