/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.style.model.AbstractStyle;
import ch.nolix.system.style.model.DeepSelectingStyle;
import ch.nolix.system.style.model.SelectingStyle;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.style.model.ISelectingStyleWithSelectors;
import ch.nolix.systemapi.style.model.IStyle;
import ch.nolix.systemapi.style.stylable.IStylableElement;

public final class Style
extends AbstractStyle<IStyle>
implements IStyle {
    public Style() {
        super(ImmutableList.createEmpty(), ImmutableList.createEmpty());
    }

    public Style(IContainer<String> attachingAttributes, IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        super(attachingAttributes, subStyles);
    }

    public static Style fromFile(String filePath) {
        Node specification = Node.fromFile(filePath);
        return Style.fromSpecification(specification);
    }

    public static Style fromSpecification(INode<?> specification) {
        LinkedList<String> attachingAttributes = LinkedList.createEmpty();
        LinkedList subStyles = LinkedList.createEmpty();
        for (INode a : specification.getStoredChildNodes()) {
            switch (a.getHeader()) {
                case "AttachingAttribute": {
                    attachingAttributes.addAtEnd(a.getStoredSingleChildNode().toString());
                    break;
                }
                case "SelectingStyle": {
                    subStyles.addAtEnd(SelectingStyle.fromSpecification(a));
                    break;
                }
                case "DeepSelectingStyle": {
                    subStyles.addAtEnd(DeepSelectingStyle.fromSpecification(a));
                    break;
                }
                default: {
                    throw InvalidArgumentException.forArgumentAndArgumentName(specification, "specification");
                }
            }
        }
        return new Style(attachingAttributes, subStyles);
    }

    @Override
    public IContainer<INode<?>> getAttributes() {
        return ContainerView.forIterables(this.getAttachingAttributes().getViewOf(a -> Node.withHeaderAndChildNode("AttachingAttribute", a, new String[0])), this.getSubStyles().getViewOf(IElement::getSpecification));
    }

    @Override
    public void applyToElement(IStylableElement<?> element) {
        this.setAttachingAttributesToElement(element);
        this.letSubStylesStyleChildElementsOfElement(element);
    }

    @Override
    public IStyle withAttachingAttributes(IContainer<String> attachingAttributes) {
        ContainerView<String> allAttachingAttributes = ContainerView.forIterables(this.getAttachingAttributes(), attachingAttributes);
        return new Style(allAttachingAttributes, this.getSubStyles());
    }

    @Override
    public IStyle withStyle(IStyle style) {
        return (IStyle)this.withAttachingAttributes((IContainer)style.getAttachingAttributes()).withSubStyles(style.getSubStyles());
    }

    @Override
    public IStyle withSubStyles(IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        LinkedList allSubStyles = LinkedList.createEmpty();
        allSubStyles.addAtEnd(this.getSubStyles());
        allSubStyles.addAtEnd(subStyles);
        return new Style(this.getAttachingAttributes(), allSubStyles);
    }
}

