/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.style.model.AbstractSelectingStyle;
import ch.nolix.system.style.model.DeepSelectingStyle;
import ch.nolix.systemapi.style.model.ISelectingStyleWithSelectors;
import ch.nolix.systemapi.style.stylable.IStylableElement;

public final class SelectingStyle
extends AbstractSelectingStyle {
    public static final String TYPE_NAME = "SelectingStyle";

    public SelectingStyle() {
        super(null, null, ImmutableList.createEmpty(), ImmutableList.createEmpty(), ImmutableList.createEmpty(), ImmutableList.createEmpty());
    }

    public SelectingStyle(String optionalSelectorId, String optionalSelectorType, IContainer<String> selectorRoles, IContainer<String> selectorTokens, IContainer<String> attachingAttributes, IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        super(optionalSelectorId, optionalSelectorType, selectorRoles, selectorTokens, attachingAttributes, subStyles);
    }

    public static SelectingStyle fromSelectingStyle(ISelectingStyleWithSelectors selectingStyle) {
        if (selectingStyle instanceof SelectingStyle) {
            SelectingStyle elementSelectingStyle = (SelectingStyle)selectingStyle;
            return elementSelectingStyle;
        }
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        return new SelectingStyle(optionalSelectorId, optionalSelectorType, selectingStyle.getSelectorRoles(), selectingStyle.getSelectorTokens(), selectingStyle.getAttachingAttributes(), selectingStyle.getSubStyles());
    }

    public static SelectingStyle fromSpecification(INode<?> specification) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        LinkedList<String> selectorRoles = LinkedList.createEmpty();
        LinkedList<String> selectorTokens = LinkedList.createEmpty();
        LinkedList<String> attachingAttributes = LinkedList.createEmpty();
        LinkedList subStyles = LinkedList.createEmpty();
        for (INode a : specification.getStoredChildNodes()) {
            switch (a.getHeader()) {
                case "SelectorId": {
                    optionalSelectorId = a.getSingleChildNodeHeader();
                    break;
                }
                case "SelectorType": {
                    optionalSelectorType = a.getSingleChildNodeHeader();
                    break;
                }
                case "SelectorRole": {
                    selectorRoles.addAtEnd(a.getSingleChildNodeHeader());
                    break;
                }
                case "SelectorToken": {
                    selectorTokens.addAtEnd(a.getSingleChildNodeHeader());
                    break;
                }
                case "AttachingAttribute": {
                    attachingAttributes.addAtEnd(a.getStoredSingleChildNode().toString());
                    break;
                }
                case "SelectingStyle": {
                    subStyles.addAtEnd(SelectingStyle.fromSpecification(a));
                    break;
                }
                case "DeepSelectingStyle": {
                    subStyles.addAtEnd(DeepSelectingStyle.fromSpecification(a));
                    break;
                }
                default: {
                    throw InvalidArgumentException.forArgumentAndArgumentName(specification, "specification");
                }
            }
        }
        return new SelectingStyle(optionalSelectorId, optionalSelectorType, selectorRoles, selectorTokens, attachingAttributes, subStyles);
    }

    @Override
    public boolean selectsChildElements() {
        return false;
    }

    @Override
    public void applyToElement(IStylableElement<?> element) {
        if (this.selectsElement(element)) {
            this.setAttachingAttributesToElement(element);
            this.letSubStylesStyleChildElementsOfElement(element);
        }
    }

    @Override
    public ISelectingStyleWithSelectors withAttachingAttributes(IContainer<String> attachingAttributes) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        ContainerView<String> allAttachingAttributes = ContainerView.forIterables(this.getAttachingAttributes(), attachingAttributes);
        return new SelectingStyle(optionalSelectorId, optionalSelectorType, this.getSelectorRoles(), this.getSelectorTokens(), allAttachingAttributes, this.getSubStyles());
    }

    @Override
    public ISelectingStyleWithSelectors withSelectorId(String selectorId) {
        Validator.assertThat(selectorId).thatIsNamed("selector id").isNotBlank();
        String optionalSelectorType = null;
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        return new SelectingStyle(selectorId, optionalSelectorType, this.getSelectorRoles(), this.getSelectorTokens(), this.getAttachingAttributes(), this.getSubStyles());
    }

    @Override
    public ISelectingStyleWithSelectors withSelectorRoles(IContainer<String> selectorRoles) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        LinkedList<String> allSelectorRoles = LinkedList.createEmpty();
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        allSelectorRoles.addAtEnd(this.getSelectorRoles());
        allSelectorRoles.addAtEnd(selectorRoles);
        return new SelectingStyle(optionalSelectorId, optionalSelectorType, allSelectorRoles, this.getSelectorTokens(), this.getAttachingAttributes(), this.getSubStyles());
    }

    @Override
    public ISelectingStyleWithSelectors withSelectorTokens(IContainer<String> selectorTokens) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        LinkedList<String> allSelectorTokens = LinkedList.createEmpty();
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        allSelectorTokens.addAtEnd(this.getSelectorTokens());
        allSelectorTokens.addAtEnd(selectorTokens);
        return new SelectingStyle(optionalSelectorId, optionalSelectorType, this.getSelectorRoles(), allSelectorTokens, this.getAttachingAttributes(), this.getSubStyles());
    }

    @Override
    public ISelectingStyleWithSelectors withSelectorType(String selectorType) {
        Validator.assertThat(selectorType).thatIsNamed("selector type").isNotBlank();
        String optionalSelectorId = null;
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        return new SelectingStyle(optionalSelectorId, selectorType, this.getSelectorRoles(), this.getSelectorTokens(), this.getAttachingAttributes(), this.getSubStyles());
    }

    @Override
    public ISelectingStyleWithSelectors withSubStyles(IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        LinkedList allSubStyles = LinkedList.createEmpty();
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        allSubStyles.addAtEnd(this.getSubStyles());
        allSubStyles.addAtEnd(subStyles);
        return new SelectingStyle(optionalSelectorId, optionalSelectorType, this.getSelectorRoles(), this.getSelectorTokens(), this.getAttachingAttributes(), allSubStyles);
    }
}

