/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.systemapi.style.model.IBaseStyle;
import ch.nolix.systemapi.style.model.ISelectingStyleWithSelectors;
import ch.nolix.systemapi.style.stylable.IStylableElement;

abstract class AbstractStyle<S extends IBaseStyle<S>>
extends AbstractElement
implements IBaseStyle<S> {
    protected static final String ATTACHING_ATTRIBUTE_HEADER = "AttachingAttribute";
    private final ImmutableList<String> memberAttachingAttributes;
    private final ImmutableList<? extends ISelectingStyleWithSelectors> memberSubStyles;

    protected AbstractStyle(IContainer<String> attachingAttributes, IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        this.memberAttachingAttributes = ImmutableList.fromIterable(attachingAttributes);
        this.memberSubStyles = ImmutableList.fromIterable(subStyles);
    }

    @Override
    public final IContainer<String> getAttachingAttributes() {
        return this.memberAttachingAttributes;
    }

    @Override
    public final IContainer<? extends ISelectingStyleWithSelectors> getSubStyles() {
        return this.memberSubStyles;
    }

    @Override
    public final boolean containsAttachingAttributes() {
        return this.memberAttachingAttributes.containsAny();
    }

    @Override
    public final S withAttachingAttributes(String ... attachingAttributes) {
        ContainerView<String> attachingAttributesView = ContainerView.forArray(attachingAttributes);
        return this.withAttachingAttributes(attachingAttributesView);
    }

    @Override
    public final S withSubStyle(ISelectingStyleWithSelectors subStyle, ISelectingStyleWithSelectors ... subStyles) {
        ContainerView<ISelectingStyleWithSelectors> allSubStyles = ContainerView.forElementAndArray(subStyle, subStyles);
        return this.withSubStyles(allSubStyles);
    }

    protected final void setAttachingAttributesToElement(IStylableElement<?> element) {
        for (String a : this.getAttachingAttributes()) {
            try {
                element.addOrChangeAttribute(a, new String[0]);
            }
            catch (Throwable error) {
                InvalidArgumentException invalidArgumentException = InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(a, "attaching attribute", "could not be added to the given " + element.getType() + " '" + String.valueOf(element.getSpecification()) + "'");
                invalidArgumentException.initCause(error);
                throw invalidArgumentException;
            }
        }
    }

    protected final void letSubStylesStyleChildElementsOfElement(IStylableElement<?> element) {
        IContainer<IStylableElement<?>> childElements = element.getStoredChildStylableElements();
        this.getSubStyles().forEach(ss -> childElements.forEach(ss::applyToElement));
    }
}

