/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlschema.statementcreator;

import ch.nolix.systemapi.sqlschema.model.ColumnConstraintDto;
import ch.nolix.systemapi.sqlschema.model.ColumnDto;
import ch.nolix.systemapi.sqlschema.model.DataTypeDto;

public final class StatementCreatorHelper {
    private StatementCreatorHelper() {
    }

    public static String getColumnAsSql(ColumnDto column) {
        String sql = column.name() + " " + StatementCreatorHelper.getDataTypeAsSql(column.dataType());
        if (column.constraints().containsAny()) {
            sql = sql + StatementCreatorHelper.getConstraintsAsSql(column);
        }
        return sql;
    }

    private static String getConstraintAsSql(ColumnConstraintDto constraint) {
        String sql = constraint.constraint().toString().replace("_", " ");
        if (constraint.parameters().containsAny()) {
            StatementCreatorHelper.getConstraintParametersAsSql(constraint);
        }
        return sql;
    }

    private static String getConstraintsAsSql(ColumnDto column) {
        return column.constraints().getViewOf(StatementCreatorHelper::getConstraintAsSql).toStringWithSeparator(",");
    }

    private static String getConstraintParametersAsSql(ColumnConstraintDto constraint) {
        return "(" + constraint.parameters().toStringWithSeparator(",") + ")";
    }

    private static String getDataTypeAsSql(DataTypeDto dataType) {
        String parameter = dataType.nullableParameter();
        if (parameter != null) {
            return dataType.name() + "(" + parameter + ")";
        }
        return dataType.name();
    }
}

