/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlschema.statementcreator;

import ch.nolix.system.sqlschema.statementcreator.StatementCreatorHelper;
import ch.nolix.systemapi.sqlschema.model.ColumnDto;
import ch.nolix.systemapi.sqlschema.model.TableDto;
import ch.nolix.systemapi.sqlschema.statementcreator.IStatementCreator;

public final class StatementCreator
implements IStatementCreator {
    @Override
    public String createStatementToAddColumn(String tableName, ColumnDto column) {
        return "ALTER TABLE " + tableName + " ADD " + StatementCreatorHelper.getColumnAsSql(column) + ";";
    }

    @Override
    public String createStatementToAddTable(TableDto table) {
        return "CREATE TABLE " + table.name() + " (" + table.columns().getViewOf(StatementCreatorHelper::getColumnAsSql).toStringWithSeparator(", ") + ");";
    }

    @Override
    public String createStatementToDeleteColumn(String tableName, String columnName) {
        return "ALTER TABLE " + tableName + " DROP COLUMN " + columnName + ";";
    }

    @Override
    public String createStatementToDeleteColumnIfExists(String tableName, String columnName) {
        return "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME ='" + tableName + "' AND COLUMN_NAME = '" + columnName + "')BEGIN ALTER TABLE " + tableName + " DROP COLUMN " + columnName + " END;";
    }

    @Override
    public String createStatementToDeleteTable(String tableName) {
        return "DROP TABLE " + tableName + ";";
    }

    @Override
    public String createStatementToRenameColumn(String tableName, String columnName, String newColumnName) {
        return "ALTER TABLE " + tableName + " RENAME COLUMN " + columnName + " TO " + newColumnName + ";";
    }

    @Override
    public String createStatementToRenameColumnIfExists(String tableName, String columnName, String newColumnName) {
        return "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME ='" + tableName + "' AND COLUMN_NAME = '" + columnName + "')BEGIN ALTER TABLE " + tableName + " RENAME COLUMN " + columnName + " TO " + newColumnName + " END;";
    }

    @Override
    public String createStatementToRenameTable(String tableName, String newTableName) {
        return "ALTER TABLE " + tableName + " RENAME TO " + newTableName + ";";
    }
}

