/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlschema.adapter;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.core.resourcecontrol.resourcevalidator.ResourceValidator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.coreapi.sql.model.ISqlRecord;
import ch.nolix.system.sqlschema.modelmapper.TableDtoMapper;
import ch.nolix.system.sqlschema.querycreator.QueryCreator;
import ch.nolix.systemapi.sqlschema.adapter.ISchemaReader;
import ch.nolix.systemapi.sqlschema.model.TableDto;
import ch.nolix.systemapi.sqlschema.modelmapper.ITableDtoMapper;
import ch.nolix.systemapi.sqlschema.querycreator.IQueryCreator;

public final class SchemaReader
implements ISchemaReader {
    private static final IQueryCreator QUERY_CREATOR = new QueryCreator();
    private static final ITableDtoMapper TABLE_DTO_MAPPER = new TableDtoMapper();
    private final ICloseController closeController = CloseController.forElement(this);
    private final ISqlConnection sqlConnection;

    private SchemaReader(String databaseName, ISqlConnection sqlConnection) {
        Validator.assertThat(databaseName).thatIsNamed("database name").isNotBlank();
        ResourceValidator.assertIsOpen(sqlConnection);
        this.sqlConnection = sqlConnection;
        this.createCloseDependencyTo(sqlConnection);
        sqlConnection.executeStatement("USE " + databaseName, new String[0]);
    }

    public static SchemaReader forDatabaseNameAndSqlConnection(String databaseName, ISqlConnection sqlConnection) {
        return new SchemaReader(databaseName, sqlConnection);
    }

    @Override
    public boolean columnIsEmpty(String tableName, String columnName) {
        String query = QUERY_CREATOR.createQueryToLoadTopFirstRecordWhereColumnIsNotNull(tableName, columnName);
        IContainer<ISqlRecord> records = this.sqlConnection.getRecordsFromQuery(query);
        return records.isEmpty();
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public int getTableCount() {
        String query = QUERY_CREATOR.createQueryToGetTableCount();
        ISqlRecord sqlRecord = this.sqlConnection.getSingleRecordFromQuery(query);
        return Integer.valueOf((String)sqlRecord.getStoredFirst());
    }

    @Override
    public TableDto loadTable(String tableName) {
        String query = QUERY_CREATOR.createQueryToLoadNameAndDataTypeOfColumns(tableName);
        IContainer<ISqlRecord> sqlRecords = this.sqlConnection.getRecordsFromQuery(query);
        return TABLE_DTO_MAPPER.mapSqlRecordsWithNameAndDataTypeToTableDto(tableName, sqlRecords);
    }

    @Override
    public IContainer<TableDto> loadTables() {
        String query = QUERY_CREATOR.createQueryToLoadTableNameAndNameAndDataTypeOfColumns();
        IContainer<ISqlRecord> sqlRecords = this.sqlConnection.getRecordsFromQuery(query);
        return TABLE_DTO_MAPPER.mapSqlRecordsWithTableNameAndNameAndDataTypeToTableDtos(sqlRecords);
    }

    @Override
    public void noteClose() {
    }

    @Override
    public boolean tableExist() {
        return this.getTableCount() > 0;
    }

    @Override
    public boolean tableExists(String tableName) {
        String query = QUERY_CREATOR.createQueryToGetTableCount(tableName);
        ISqlRecord records = this.sqlConnection.getSingleRecordFromQuery(query);
        return Integer.valueOf((String)records.getStoredFirst()) > 0;
    }
}

