/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmidschema.statementcreator;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.system.sqlmidschema.statementcreator.ColumnTableStatementCreator;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.sqlmidschema.databasestructure.BackReferenceableColumnColumn;
import ch.nolix.systemapi.sqlmidschema.databasestructure.ColumnColumn;
import ch.nolix.systemapi.sqlmidschema.databasestructure.FixTable;
import ch.nolix.systemapi.sqlmidschema.databasestructure.ReferenceableTableColumn;
import ch.nolix.systemapi.sqlmidschema.databasestructure.TableColumn;
import ch.nolix.systemapi.sqlmidschema.statementcreator.IColumnTableStatementCreator;
import ch.nolix.systemapi.sqlmidschema.statementcreator.ISchemaDataStatementCreator;

public final class SchemaDataStatementCreator
implements ISchemaDataStatementCreator {
    private static final IColumnTableStatementCreator COLUMN_TABLE_STATEMENT_CREATOR = new ColumnTableStatementCreator();

    @Override
    public String createStatementToAddBackReferenceableColumn(ColumnIdentification parentBaseBackReferenceColumn, String referenceableColumnId) {
        return "INSERT INTO " + FixTable.BACK_REFERENCEABLE_COLUMN.getName() + " (" + BackReferenceableColumnColumn.PARENT_BASE_BACK_REFERENCE_COLUMN_ID.getName() + ", " + BackReferenceableColumnColumn.BACK_REFERENCEABLE_COLUMN_ID.getName() + ") VALUES ('" + parentBaseBackReferenceColumn.columnId() + "', '" + referenceableColumnId + "');";
    }

    @Override
    public IContainer<String> createStatementsToAddColumn(TableIdentification table, ColumnDto column) {
        LinkedList<String> statements = LinkedList.createEmpty();
        String columnId = column.id();
        String columnName = column.name();
        ColumnIdentification columnIdentification = new ColumnIdentification(columnId, columnName);
        statements.addAtEnd(COLUMN_TABLE_STATEMENT_CREATOR.createStatementToAddColumnIntoColumnTable(table, column));
        for (String t : column.referenceableTableIds()) {
            statements.addAtEnd(this.createStatementToAddReferenceableTable(columnIdentification, t));
        }
        for (String c : column.backReferenceableColumnIds()) {
            statements.addAtEnd(this.createStatementToAddBackReferenceableColumn(columnIdentification, c));
        }
        return statements;
    }

    @Override
    public String createStatementToAddReferenceableTable(ColumnIdentification parentBaseReferenceColumn, String referenceableTableId) {
        return "INSERT INTO " + FixTable.REFERENCEABLE_TABLE.getName() + " (" + ReferenceableTableColumn.PARENT_BASE_REFERENCE_COLUMN_ID.getName() + ", " + ReferenceableTableColumn.REFERENCEABLE_TABLE_ID.getName() + ") VALUES ('" + parentBaseReferenceColumn.columnId() + "', '" + referenceableTableId + "');";
    }

    @Override
    public String createStatementToAddTable(String tableId, String tableName) {
        return "INSERT INTO " + FixTable.TABLE.getName() + " (" + TableColumn.ID.getName() + ", " + TableColumn.NAME.getName() + ") VALUES ('" + tableId + "', '" + tableName + "')";
    }

    public ILinkedList<String> createStatementsToAddTable(TableDto table) {
        LinkedList<String> statements = LinkedList.createEmpty();
        statements.addAtEnd(this.createStatementToAddTable(table.id(), table.name()));
        for (ColumnDto c : table.columns()) {
            String tableId = table.id();
            String tablename = table.name();
            TableIdentification tableIdentification = new TableIdentification(tableId, tablename);
            statements.addAtEnd(this.createStatementsToAddColumn(tableIdentification, c));
        }
        return statements;
    }

    @Override
    public String createStatementToDeleteColumn(TableIdentification table, String columnName) {
        return "DELETE FROM " + FixTable.COLUMN.getName() + " WHERE " + ColumnColumn.PARENT_TABLE_ID.getName() + " = '" + table.tableId() + "' AND " + ColumnColumn.NAME.getName() + " = '" + columnName + "';";
    }

    @Override
    public String createStatementToDeleteTable(String tableName) {
        return "DELETE FROM " + FixTable.TABLE.getName() + " WHERE " + String.valueOf(TableColumn.NAME) + " = '" + tableName + "'";
    }

    @Override
    public String createStatementToRenameColumn(String tableName, String columnName, String newColumnName) {
        return "UPDATE " + FixTable.COLUMN.getName() + " SET " + String.valueOf(ColumnColumn.NAME) + " = '" + newColumnName + "' WHERE " + ColumnColumn.PARENT_TABLE_ID.getName() + " = '" + tableName + "' AND " + ColumnColumn.NAME.getName() + " = '" + columnName + "'";
    }

    @Override
    public String createStatementToRenameTable(String tableName, String newTableName) {
        return "UPDATE " + FixTable.TABLE.getName() + " SET " + TableColumn.NAME.getName() + " = '" + newTableName + "' WHERE " + TableColumn.NAME.getName() + " = '" + tableName + "'";
    }

    @Override
    public IContainer<String> createStatementsToSetContentModel(TableIdentification table, ColumnIdentification column, FieldType fieldType, DataType dataType, IContainer<String> referenceableTableIds, IContainer<String> backReferenceableColumnIds) {
        LinkedList<String> statements = LinkedList.createEmpty();
        String statementToSetContentModelInColumnTable = COLUMN_TABLE_STATEMENT_CREATOR.createStatementToSetContentModelInColumnTable(column, fieldType, dataType);
        statements.addAtEnd(statementToSetContentModelInColumnTable);
        IContainer<String> statementsToAddReferenceableTables = referenceableTableIds.getViewOf(t -> this.createStatementToAddReferenceableTable(column, (String)t));
        statements.addAtEnd(statementsToAddReferenceableTables);
        IContainer<String> statementsToAddBackReferenceableColumns = backReferenceableColumnIds.getViewOf(c -> this.createStatementToAddBackReferenceableColumn(column, (String)c));
        statements.addAtEnd(statementsToAddBackReferenceableColumns);
        return statements;
    }
}

