/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmidschema.schemawriter;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.sql.sqltool.SqlCollector;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.coreapi.sql.sqltool.ISqlCollector;
import ch.nolix.system.sqlmidschema.statementcreator.DatabasePropertiesStatementCreator;
import ch.nolix.system.sqlmidschema.statementcreator.SchemaDataStatementCreator;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.sqlmidschema.statementcreator.IDatabasePropertiesStatementCreator;
import ch.nolix.systemapi.sqlmidschema.statementcreator.ISchemaDataStatementCreator;
import ch.nolix.systemapi.time.moment.ITime;

public final class SchemaDataWriter {
    private static final IDatabasePropertiesStatementCreator DATABASE_PROPERTIES_STATEMENT_CREATOR = new DatabasePropertiesStatementCreator();
    private static final ISchemaDataStatementCreator META_DATA_STATEMENT_CREATOR = new SchemaDataStatementCreator();
    private final ISqlCollector sqlCollector;

    private SchemaDataWriter(ISqlCollector sqlCollector) {
        Validator.assertThat(sqlCollector).thatIsNamed(SqlCollector.class).isNotNull();
        this.sqlCollector = sqlCollector;
    }

    public static SchemaDataWriter forSqlCollector(ISqlCollector sqlCollector) {
        return new SchemaDataWriter(sqlCollector);
    }

    public void addColumn(TableIdentification table, ColumnDto column) {
        IContainer<String> statements = META_DATA_STATEMENT_CREATOR.createStatementsToAddColumn(table, column);
        this.sqlCollector.addSqlStatements(statements);
    }

    public void deleteColumn(TableIdentification table, String columnName) {
        String statement = META_DATA_STATEMENT_CREATOR.createStatementToDeleteColumn(table, columnName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void addTable(TableDto table) {
        IContainer<String> statements = META_DATA_STATEMENT_CREATOR.createStatementsToAddTable(table);
        this.sqlCollector.addSqlStatements(statements);
    }

    public void deleteTable(String tableName) {
        String statement = META_DATA_STATEMENT_CREATOR.createStatementToDeleteTable(tableName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void renameColumn(String tableName, String columnName, String newColumnName) {
        String statement = META_DATA_STATEMENT_CREATOR.createStatementToRenameColumn(tableName, columnName, newColumnName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void renameTable(String tableName, String newTableName) {
        String statement = META_DATA_STATEMENT_CREATOR.createStatementToRenameTable(tableName, newTableName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void setContentModel(TableIdentification table, ColumnIdentification column, FieldType fieldType, DataType dataType, IContainer<String> referenceableTableIds, IContainer<String> backReferenceableColumnIds) {
        IContainer<String> statements = META_DATA_STATEMENT_CREATOR.createStatementsToSetContentModel(table, column, fieldType, dataType, referenceableTableIds, backReferenceableColumnIds);
        this.sqlCollector.addSqlStatements(statements);
    }

    public void setSchemaTimestamp(ITime schemaTimestamp) {
        String statement = DATABASE_PROPERTIES_STATEMENT_CREATOR.createStatementToSetSchemaTimestamp(schemaTimestamp);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }
}

