/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.modeltool;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentBelongsToParentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotBelongToParentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.systemapi.midschema.fieldproperty.BaseFieldType;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modeltool.IColumnTool;

public final class ColumnTool
extends DatabaseObjectExaminer
implements IColumnTool {
    @Override
    public void assertBelongsToTable(IColumn column) {
        if (!column.belongsToTable()) {
            throw ArgumentDoesNotBelongToParentException.forArgumentAndParentType(column, ITable.class);
        }
    }

    @Override
    public void assertDoesNotBelongToTable(IColumn column) {
        if (column.belongsToTable()) {
            throw ArgumentBelongsToParentException.forArgumentAndParent(column, column.getStoredParentTable());
        }
    }

    @Override
    public void assertIsABackReferenceColumn(IColumn column) {
        if (!this.isABackReferenceColumn(column)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(column, "is not a back reference column");
        }
    }

    @Override
    public void assertIsAReferenceColumn(IColumn column) {
        if (!this.isAReferenceColumn(column)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(column, "is not any reference column");
        }
    }

    @Override
    public boolean belongsToDatabase(IColumn column) {
        return column.belongsToTable() && ((ITable)column.getStoredParentTable()).belongsToDatabase();
    }

    @Override
    public BaseFieldType getBaseFieldType(IColumn column) {
        return column.getFieldType().getBaseType();
    }

    @Override
    public IDatabase getParentDatabase(IColumn column) {
        return (IDatabase)((ITable)column.getStoredParentTable()).getStoredParentDatabase();
    }

    @Override
    public boolean isABackReferenceColumn(IColumn column) {
        return column != null && column.getFieldType().getBaseType() == BaseFieldType.BASE_BACK_REFERENCE;
    }

    @Override
    public boolean isAReferenceColumn(IColumn column) {
        return column != null && column.getFieldType().getBaseType() == BaseFieldType.BASE_REFERENCE;
    }

    @Override
    public boolean isAValueColumn(IColumn column) {
        return column != null && column.getFieldType().getBaseType() == BaseFieldType.BASE_VALUE_FIELD;
    }

    @Override
    public boolean isAValidBackReferenceColumn(IColumn column) {
        FieldType fieldType = column.getFieldType();
        BaseFieldType baseType = fieldType.getBaseType();
        if (baseType == BaseFieldType.BASE_BACK_REFERENCE) {
            ITable table = (ITable)column.getStoredParentTable();
            IContainer<? extends IColumn> backReferenceableColumns = column.getStoredBackReferenceableColumns();
            for (IColumn iColumn : backReferenceableColumns) {
                if (this.isAReferenceColumn(iColumn) && this.referencesGivenTable(iColumn, table)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean referencesBackGivenColumn(IColumn column, IColumn probableBackReferencedColumn) {
        return column.referencesBackColumn(probableBackReferencedColumn);
    }

    @Override
    public boolean referencesGivenTable(IColumn column, ITable table) {
        return column.referencesTable(table);
    }
}

