/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.modelexaminer;

import ch.nolix.system.objectschema.modeltool.ColumnTool;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modelexaminer.ITableExaminer;
import ch.nolix.systemapi.objectschema.modeltool.IColumnTool;

public final class TableExaminer
implements ITableExaminer {
    private static final IColumnTool COLUMN_TOOL = new ColumnTool();

    @Override
    public boolean containsColumn(ITable table, IColumn column) {
        return table != null && table.getStoredColumns().contains(column);
    }

    @Override
    public boolean containsColumnThatIsBackReferencedByColumn(ITable table, IColumn column) {
        return table != null && COLUMN_TOOL.isABackReferenceColumn(column) && table.getStoredColumns().containsAny(c -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, column));
    }

    @Override
    public boolean containsColumnThatReferencesBackColumn(ITable table, IColumn column) {
        return table != null && COLUMN_TOOL.isAReferenceColumn(column) && table.getStoredColumns().containsAny(c -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, column));
    }

    @Override
    public boolean containsColumnThatReferencesTable(ITable table, ITable otherTable) {
        return table != null && table.getStoredColumns().containsAny(c -> COLUMN_TOOL.referencesGivenTable((IColumn)c, otherTable));
    }

    @Override
    public boolean containsColumnWithName(ITable table, String name) {
        return table != null && table.getStoredColumns().containsAny(c -> c.hasName(name));
    }

    @Override
    public boolean isReferenced(ITable table) {
        return table != null && table.belongsToDatabase() && ((IDatabase)table.getStoredParentDatabase()).getStoredTables().containsAny(t -> this.containsColumnThatReferencesTable((ITable)t, table));
    }
}

