/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectschema.model.Column;
import ch.nolix.system.objectschema.model.ColumnMapper;
import ch.nolix.system.objectschema.model.Table;
import ch.nolix.systemapi.midschema.model.TableDto;

public final class TableMapper {
    private TableMapper() {
    }

    public static IContainer<Table> mapMidSchemaTableDtosToLoadedTables(IContainer<TableDto> midSchemaTableDtos) {
        IContainer<Table> tables = TableMapper.mapMidSchemaTableDtosToEmptyLoadedTables(midSchemaTableDtos);
        for (Table t : tables) {
            String id = t.getId();
            TableDto midschemaTableDto = midSchemaTableDtos.getStoredFirst(m -> m.id().equals(id));
            IContainer<Column> columns = ColumnMapper.mapMidSchemaTableDtoToLoadedColumns(midschemaTableDto, tables);
            columns.forEach(t::addColumnAttribute);
        }
        return tables;
    }

    private static IContainer<Table> mapMidSchemaTableDtosToEmptyLoadedTables(IContainer<TableDto> midSchemaTableDtos) {
        return midSchemaTableDtos.to(TableMapper::mapMidSchemaTableDtoToEmptyTable);
    }

    private static Table mapMidSchemaTableDtoToEmptyTable(TableDto midSchemaTableDto) {
        String id = midSchemaTableDto.id();
        String name = midSchemaTableDto.name();
        Table table = Table.withIdAndName(id, name);
        table.setLoaded();
        return table;
    }
}

