/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.coreapi.attribute.mandatoryattribute.IIdHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.system.objectschema.model.Column;
import ch.nolix.system.objectschema.model.Table;
import ch.nolix.system.objectschema.modelmutationvalidator.ColumnMutationValidator;
import ch.nolix.systemapi.midschema.adapter.ISchemaAdapter;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modeleditor.IColumnEditor;
import ch.nolix.systemapi.objectschema.modelmutationvalidator.IColumnMutationValidator;

public final class ColumnEditor
implements IColumnEditor<Column> {
    private static final IColumnMutationValidator COLUMN_MUTATION_VALIDATOR = new ColumnMutationValidator();

    @Override
    public void deleteColumn(Column column) {
        COLUMN_MUTATION_VALIDATOR.assertCanBeDeleted(column);
        Table table = column.getStoredParentTable();
        String tableId = table.getId();
        String tableName = table.getName();
        column.getStoredMidSchemaAdapter().deleteColumn(new TableIdentification(tableId, tableName), column.getName());
        column.getStoredParentTable().removeColumnAttribute(column);
        column.setDeleted();
    }

    @Override
    public void setContentModelToColumn(Column column, FieldType fieldType, DataType dataType, IContainer<? extends ITable> referenceableTables, IContainer<? extends IColumn> backReferenceableColumns) {
        COLUMN_MUTATION_VALIDATOR.assertCanSetContentModel(column, fieldType, dataType, referenceableTables, backReferenceableColumns);
        column.setContentModelAttribute(fieldType, dataType, referenceableTables, backReferenceableColumns);
        column.setEdited();
        if (column.isConnectedWithRealDatabase()) {
            Table table = column.getStoredParentTable();
            String tableId = table.getId();
            String tableName = table.getName();
            TableIdentification tableIdentification = new TableIdentification(tableId, tableName);
            String columnId = column.getId();
            String columnName = column.getName();
            ColumnIdentification columnIdentification = new ColumnIdentification(columnId, columnName);
            IContainer<String> referenceableTableIds = referenceableTables.to(IIdHolder::getId);
            IContainer<String> backReferenceableColumnIds = backReferenceableColumns.to(IIdHolder::getId);
            ISchemaAdapter midSchemaAdapter = column.getStoredMidSchemaAdapter();
            midSchemaAdapter.setColumnModel(tableIdentification, columnIdentification, fieldType, dataType, referenceableTableIds, backReferenceableColumnIds);
        }
    }

    @Override
    public void setNameToColumn(Column column, String name) {
        COLUMN_MUTATION_VALIDATOR.assertCanSetName(column, name);
        String oldName = column.getName();
        column.setNameAttribute(name);
        column.setEdited();
        if (column.isConnectedWithRealDatabase()) {
            String tableName = column.getStoredParentTable().getName();
            ISchemaAdapter midSchemaAdapter = column.getStoredMidSchemaAdapter();
            midSchemaAdapter.renameColumn(tableName, oldName, name);
        }
    }
}

