/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.core.container.arraylist.ArrayList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.datamodel.id.IdCreator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.attribute.mandatoryattribute.IIdHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.IArrayList;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.system.objectschema.model.AbstractSchemaObject;
import ch.nolix.system.objectschema.model.ColumnEditor;
import ch.nolix.system.objectschema.model.Database;
import ch.nolix.system.objectschema.model.Table;
import ch.nolix.system.objectschema.modeltool.ColumnTool;
import ch.nolix.system.objectschema.modelvalidator.ColumnValidator;
import ch.nolix.systemapi.midschema.adapter.ISchemaAdapter;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modeleditor.IColumnEditor;
import ch.nolix.systemapi.objectschema.modeltool.IColumnTool;
import ch.nolix.systemapi.objectschema.modelvalidator.IColumnValidator;

public final class Column
extends AbstractSchemaObject
implements IColumn {
    private static final String INITIAL_HEADER = "Default";
    private static final IColumnEditor<Column> COLUMN_EDITOR = new ColumnEditor();
    private static final IColumnTool COLUMN_TOOL = new ColumnTool();
    private static final IColumnValidator COLUMN_VALIDATOR = new ColumnValidator();
    private final String id;
    private Table parentTable;
    private String name = "Default";
    private FieldType fieldType = FieldType.VALUE_FIELD;
    private DataType dataType = DataType.STRING;
    private final IArrayList<ITable> referenceableTables = ArrayList.createEmpty();
    private final IArrayList<IColumn> backReferenceableColumns = ArrayList.createEmpty();

    public Column(String name, FieldType fieldType, DataType dataType, IContainer<? extends ITable> referenceableTables, IContainer<? extends IColumn> backReferenceableColumns) {
        this(IdCreator.createIdOf10HexadecimalCharacters(), name, fieldType, dataType, referenceableTables, backReferenceableColumns);
    }

    private Column(String id, String name, FieldType fieldType, DataType dataType, IContainer<? extends ITable> referenceableTables, IContainer<? extends IColumn> backReferenceableColumns) {
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        this.id = id;
        this.setName(name);
        this.referenceableTables.addAtEnd((Iterable<ITable>)referenceableTables);
        this.setContentModel(fieldType, dataType, (IContainer)referenceableTables, (IContainer)backReferenceableColumns);
    }

    public static Column withIdAndNameAndContentModel(String id, String name, FieldType fieldType, DataType dataType, IContainer<? extends ITable> referenceableTables, IContainer<? extends IColumn> backReferenceableColumns) {
        return new Column(id, name, fieldType, dataType, referenceableTables, backReferenceableColumns);
    }

    @Override
    public boolean belongsToDatabase() {
        return this.parentTable != null && this.parentTable.belongsToDatabase();
    }

    @Override
    public boolean belongsToTable() {
        return this.parentTable != null;
    }

    @Override
    public void delete() {
        COLUMN_EDITOR.deleteColumn(this);
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IContainer<? extends IColumn> getStoredBackReferenceableColumns() {
        return this.backReferenceableColumns;
    }

    @Override
    public IDatabase getStoredParentDatabase() {
        return this.getStoredParentTable().getStoredParentDatabase();
    }

    @Override
    public Table getStoredParentTable() {
        COLUMN_TOOL.assertBelongsToTable(this);
        return this.parentTable;
    }

    @Override
    public IContainer<? extends ITable> getStoredReferenceableTables() {
        return this.referenceableTables;
    }

    @Override
    public boolean isBackReferenced() {
        if (!COLUMN_TOOL.isAReferenceColumn(this)) {
            return false;
        }
        return this.isBackReferencedWhenIsAnyReferenceColumn();
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.belongsToTable() && this.getStoredParentTable().isConnectedWithRealDatabase();
    }

    @Override
    public boolean isEmpty() {
        return this.isNew() || this.getStoredMidSchemaAdapter().columnIsEmpty(this.getStoredParentTable().getName(), this.getName());
    }

    @Override
    public boolean referencesBackColumn(IColumn column) {
        return this.getStoredBackReferenceableColumns().contains(column);
    }

    @Override
    public boolean referencesTable(ITable table) {
        return this.referenceableTables.contains(table);
    }

    @Override
    public Column setContentModel(FieldType fieldType, DataType dataType, IContainer<? extends ITable> referenceableTables, IContainer<? extends IColumn> backReferenceableColumns) {
        COLUMN_EDITOR.setContentModelToColumn(this, fieldType, dataType, referenceableTables, backReferenceableColumns);
        return this;
    }

    @Override
    public Column setName(String name) {
        COLUMN_EDITOR.setNameToColumn(this, name);
        return this;
    }

    IContainer<? extends IColumn> getStoredBackReferencingColumns() {
        if (!COLUMN_TOOL.isAReferenceColumn(this)) {
            return LinkedList.createEmpty();
        }
        return this.getStoredBackReferencingColumnsWhenIsReferenceColumn();
    }

    ISchemaAdapter getStoredMidSchemaAdapter() {
        return ((Database)COLUMN_TOOL.getParentDatabase(this)).getStoredMidSchemaAdapter();
    }

    void internalSetContentModelToDatabase() {
        Table table = this.getStoredParentTable();
        String tableId = table.getId();
        String tableName = table.getName();
        TableIdentification tableIdentification = new TableIdentification(tableId, tableName);
        String columnId = this.getId();
        String columnName = this.getName();
        ColumnIdentification columnIdentification = new ColumnIdentification(columnId, columnName);
        FieldType localFieldType = this.getFieldType();
        DataType localDataType = this.getDataType();
        IContainer<String> referenceableTableIdsView = this.getStoredReferenceableTables().getViewOf(IIdHolder::getId);
        IContainer<String> backReferenceableColumnIdsView = this.getStoredBackReferenceableColumns().getViewOf(IIdHolder::getId);
        this.getStoredMidSchemaAdapter().setColumnModel(tableIdentification, columnIdentification, localFieldType, localDataType, referenceableTableIdsView, backReferenceableColumnIdsView);
    }

    void setNameAttribute(String header) {
        this.name = header;
    }

    void setContentModelAttribute(FieldType fieldType, DataType dataType, IContainer<? extends ITable> referenceableTables, IContainer<? extends IColumn> backReferenceableColumns) {
        COLUMN_VALIDATOR.assertCanSetContentModel(this, fieldType, dataType, referenceableTables, backReferenceableColumns);
        this.referenceableTables.clear();
        this.backReferenceableColumns.clear();
        this.fieldType = fieldType;
        this.dataType = dataType;
        this.referenceableTables.addAtEnd((Iterable<ITable>)referenceableTables);
        this.backReferenceableColumns.addAtEnd((Iterable<IColumn>)backReferenceableColumns);
    }

    void setParentTableAttribute(Table parentTable) {
        this.parentTable = parentTable;
    }

    @Override
    protected void noteClose() {
    }

    private IContainer<? extends IColumn> getStoredBackReferencingColumnsWhenIsReferenceColumn() {
        if (COLUMN_TOOL.belongsToDatabase(this)) {
            return COLUMN_TOOL.getParentDatabase(this).getStoredTables().toMultiples(t -> t.getStoredColumns().getStoredSelected(c -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, this)));
        }
        if (this.belongsToTable()) {
            return this.getStoredParentTable().getStoredColumns().getStoredSelected(c -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, this));
        }
        return LinkedList.createEmpty();
    }

    private boolean isBackReferencedWhenIsAnyReferenceColumn() {
        if (COLUMN_TOOL.belongsToDatabase(this)) {
            return COLUMN_TOOL.getParentDatabase(this).getStoredTables().containsAny(t -> t.getStoredColumns().containsAny(c -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, this)));
        }
        if (this.belongsToTable()) {
            return this.getStoredParentTable().getStoredColumns().containsAny(c -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, this));
        }
        return false;
    }
}

