/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.adapter;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.system.objectschema.model.Database;
import ch.nolix.system.objectschema.modelsearcher.DatabaseSearcher;
import ch.nolix.system.objectschema.modelvalidator.DatabaseValidator;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modelsearcher.IDatabaseSearcher;
import ch.nolix.systemapi.objectschema.modelvalidator.IDatabaseValidator;
import ch.nolix.systemapi.objectschema.schemaadapter.ISchemaAdapter;

public abstract class AbstractSchemaAdapter
implements ISchemaAdapter {
    private static final IDatabaseSearcher DATABASE_SEARCHER = new DatabaseSearcher();
    private static final IDatabaseValidator DATABASE_VALIDATOR = new DatabaseValidator();
    private final ICloseController closeController = CloseController.forElement(this);
    private IDatabase database;
    private final ch.nolix.systemapi.midschema.adapter.ISchemaAdapter midSchemaAdapter;
    private int saveCount;

    protected AbstractSchemaAdapter(String databaseName, ch.nolix.systemapi.midschema.adapter.ISchemaAdapter midSchemaAdapter) {
        Validator.assertThat(midSchemaAdapter).thatIsNamed(ch.nolix.systemapi.midschema.adapter.ISchemaAdapter.class).isNotNull();
        this.midSchemaAdapter = midSchemaAdapter;
        this.getStoredCloseController().createCloseDependencyTo(this.midSchemaAdapter);
        this.resetUsingDatabaseName(databaseName);
    }

    @Override
    public ISchemaAdapter addTable(ITable table) {
        this.database.addTable(table);
        return this;
    }

    @Override
    public final boolean databaseIsEmpty() {
        return this.getTableCount() == 0;
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public final ITable getStoredTableByName(String name) {
        return DATABASE_SEARCHER.getStoredTableByName(this.database, name);
    }

    @Override
    public final IContainer<ITable> getStoredTables() {
        return this.database.getStoredTables();
    }

    @Override
    public final int getSaveCount() {
        return this.saveCount;
    }

    @Override
    public final int getTableCount() {
        return this.database.getTableCount();
    }

    @Override
    public final boolean hasChanges() {
        return this.midSchemaAdapter.hasChanges();
    }

    @Override
    public final void noteClose() {
    }

    @Override
    public final void reset() {
        this.resetUsingDatabaseName(this.database.getName());
    }

    @Override
    public final void saveChanges() {
        try {
            DATABASE_VALIDATOR.assertAllBackReferencesAreValid(this.database);
            this.midSchemaAdapter.saveChanges();
            ++this.saveCount;
        }
        finally {
            this.reset();
        }
    }

    private void resetUsingDatabaseName(String databaseName) {
        this.database = new Database(databaseName, this.midSchemaAdapter);
        this.midSchemaAdapter.reset();
    }
}

