/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.schemamapper;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.system.objectdata.model.AbstractBaseBackReference;
import ch.nolix.system.objectdata.model.AbstractBaseReference;
import ch.nolix.system.objectdata.model.AbstractBaseValueField;
import ch.nolix.system.objectschema.model.Column;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.schemamapper.IColumnMapper;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.ITable;

public final class ColumnMapper
implements IColumnMapper {
    @Override
    public IColumn mapFieldToColumn(IField field, IContainer<ITable> tables) {
        if (field instanceof AbstractBaseValueField) {
            AbstractBaseValueField baseValueField = (AbstractBaseValueField)field;
            return new Column(field.getName(), field.getType(), DataType.forType(baseValueField.getValueType()), ImmutableList.createEmpty(), ImmutableList.createEmpty());
        }
        if (field instanceof AbstractBaseReference) {
            AbstractBaseReference baseReference = (AbstractBaseReference)field;
            IContainer<String> referenceableTableNames = baseReference.getReferenceableTableNames();
            IContainer<ITable> referenceableTables = tables.getStoredSelected(t -> referenceableTableNames.containsAny(t.getName(), new Object[0]));
            return new Column(field.getName(), field.getType(), DataType.STRING, referenceableTables, ImmutableList.createEmpty());
        }
        if (field instanceof AbstractBaseBackReference) {
            AbstractBaseBackReference baseBackReference = (AbstractBaseBackReference)field;
            String backReferencedFieldName = baseBackReference.getBackReferencedFieldName();
            IContainer<String> backReferenceableTableNames = baseBackReference.getBackReferenceableTableNames();
            IContainer<ITable> backReferenceableTables = tables.getStoredSelected(t -> backReferenceableTableNames.contains(t.getName()));
            IContainer<IColumn> backReferenceableColumns = backReferenceableTables.to(t -> t.getStoredColumns().getStoredFirst(c -> c.hasName(backReferencedFieldName)));
            return new Column(field.getName(), field.getType(), DataType.STRING, ImmutableList.createEmpty(), backReferenceableColumns);
        }
        throw InvalidArgumentException.forArgument(field);
    }
}

