/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.persistence;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.middatamodelmapper.MultiReferenceEntryDeletionDtoMapper;
import ch.nolix.system.objectdata.middatamodelmapper.MultiReferenceEntryDtoMapper;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDeletionDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDto;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IMultiReferenceEntryDeletionDtoMapper;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IMultiReferenceEntryDtoMapper;
import ch.nolix.systemapi.objectdata.model.IMultiReferenceEntry;
import ch.nolix.systemapi.objectdata.perstistence.IMultiReferenceEntrySaver;

public final class MultiReferenceEntrySaver
implements IMultiReferenceEntrySaver {
    private static final IMultiReferenceEntryDtoMapper MULTI_REFERENCE_ENTRY_DTO_MAPPER = new MultiReferenceEntryDtoMapper();
    private static final IMultiReferenceEntryDeletionDtoMapper MULTI_REFERENCE_ENTRY_DELETION_DTO_MAPPER = new MultiReferenceEntryDeletionDtoMapper();

    @Override
    public void saveMultiReferenceEntryChange(IMultiReferenceEntry<?> multiReferenceEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        DatabaseObjectState state = (DatabaseObjectState)((Object)multiReferenceEntry.getState());
        switch (state) {
            case NEW: {
                this.saveMultiReferenceEntryCreation(multiReferenceEntry, dataAndSchemaAdapter);
                break;
            }
            case UNEDITED: {
                break;
            }
            case DELETED: {
                this.saveMultiReferenceEntryDeletion(multiReferenceEntry, dataAndSchemaAdapter);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName((Object)state, "state of multi reference entry");
            }
        }
    }

    @Override
    public void saveMultiReferenceEntryCreation(IMultiReferenceEntry<?> multiReferenceEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        MultiReferenceEntryDto multiReferenceEntryDto = MULTI_REFERENCE_ENTRY_DTO_MAPPER.mapMultiReferenceEntryToMultiReferenceEntryDto(multiReferenceEntry);
        dataAndSchemaAdapter.insertMultiReferenceEntry(multiReferenceEntryDto);
    }

    @Override
    public void saveMultiReferenceEntryDeletion(IMultiReferenceEntry<?> multiReferenceEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        MultiReferenceEntryDeletionDto multiReferenceEntryDeletionDto = MULTI_REFERENCE_ENTRY_DELETION_DTO_MAPPER.mapMultiReferenceEntryToMultiReferenceEntryDeletionDto(multiReferenceEntry);
        dataAndSchemaAdapter.deleteMultiReferenceEntry(multiReferenceEntryDeletionDto);
    }
}

