/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.persistence;

import ch.nolix.core.misc.function.FunctionService;
import ch.nolix.system.objectdata.fieldexaminer.FieldExaminer;
import ch.nolix.system.objectdata.persistence.MultiBackReferenceSaver;
import ch.nolix.system.objectdata.persistence.MultiReferenceSaver;
import ch.nolix.system.objectdata.persistence.MultiValueFieldSaver;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.objectdata.fieldexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiReference;
import ch.nolix.systemapi.objectdata.model.IMultiValueField;
import ch.nolix.systemapi.objectdata.perstistence.IMultiFieldSaver;
import ch.nolix.systemapi.objectdata.perstistence.IMultiValueFieldSaver;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class MultiFieldSaver
implements IMultiFieldSaver {
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private static final IMultiValueFieldSaver MULTI_VALUE_FIELD_SAVER = new MultiValueFieldSaver();
    private static final MultiReferenceSaver MULTI_REFERENCE_SAVER = new MultiReferenceSaver();
    private static final MultiBackReferenceSaver MULTI_BACK_REFERENCE_SAVER = new MultiBackReferenceSaver();

    @Override
    public void saveFieldChangesIfIsMultiField(IField field, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        IField iField = field;
        Objects.requireNonNull(iField);
        IField iField2 = iField;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IMultiValueField.class, IMultiReference.class, IMultiBackReference.class}, (Object)iField2, 0)) {
            case 0: {
                IMultiValueField multiValueField = (IMultiValueField)iField2;
                MULTI_VALUE_FIELD_SAVER.saveMultiValueFieldChanges(multiValueField, dataAndSchemaAdapter);
                break;
            }
            case 1: {
                IMultiReference multiReference = (IMultiReference)iField2;
                MULTI_REFERENCE_SAVER.saveMultiReferenceChanges(multiReference, dataAndSchemaAdapter);
                break;
            }
            case 2: {
                IMultiBackReference multiBackReference = (IMultiBackReference)iField2;
                MULTI_BACK_REFERENCE_SAVER.saveMultiBackReferenceChanges(multiBackReference, dataAndSchemaAdapter);
                break;
            }
            default: {
                FunctionService.doNothing();
            }
        }
    }

    @Override
    public void saveMultiFieldChangesOfEntity(IEntity entity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        DatabaseObjectState entityState = (DatabaseObjectState)((Object)entity.getState());
        switch (entityState) {
            case NEW: 
            case DELETED: {
                for (IField iField : entity.internalGetStoredFields()) {
                    this.saveFieldChangesIfIsMultiField(iField, dataAndSchemaAdapter);
                }
                break;
            }
            case EDITED: {
                for (IField iField : entity.internalGetStoredFields()) {
                    this.saveFieldChangesIfIsNewOrEditedMultiField(iField, dataAndSchemaAdapter);
                }
                break;
            }
        }
    }

    private void saveFieldChangesIfIsNewOrEditedMultiField(IField field, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        if (FIELD_EXAMINER.isNewOrEdited(field)) {
            this.saveFieldChangesIfIsMultiField(field, dataAndSchemaAdapter);
        }
    }
}

