/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.modelexaminer;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectdata.fieldexaminer.FieldExaminer;
import ch.nolix.system.objectdata.modelexaminer.EntityExaminerHelper;
import ch.nolix.systemapi.objectdata.fieldexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelexaminer.IEntityExaminer;
import ch.nolix.systemapi.objectdata.modelexaminer.IEntityExaminerHelper;

public final class EntityExaminer
extends DatabaseObjectExaminer
implements IEntityExaminer {
    private static final IEntityExaminerHelper ENTITY_EXAMINER_HELPER = new EntityExaminerHelper();
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();

    @Override
    public boolean allNewAndEditedMandatoryFieldsAreSet(IEntity entity) {
        if (this.isNewOrEdited(entity)) {
            return entity.internalGetStoredFields().containsOnly(FIELD_EXAMINER::isSetForCaseWhenIsMandatoryAndNewOrEdited);
        }
        return true;
    }

    @Override
    public boolean canBeDeleted(IEntity entity) {
        return entity != null && entity.isLoaded() && !this.isReferencedIgnoringLocallyDeletedEntities(entity);
    }

    @Override
    public boolean canBeInsertedIntoTable(IEntity entity) {
        return entity != null && entity.isNew() && entity.belongsToTable();
    }

    @Override
    public boolean canSetParentTable(IEntity entity) {
        return entity != null && entity.isOpen() && !entity.belongsToTable();
    }

    @Override
    public boolean canSetParentTable(IEntity entity, ITable<? extends IEntity> table) {
        return this.canSetParentTable(entity) && table != null && table.isOpen() && entity.getClass() == table.getEntityType();
    }

    @Override
    public boolean isReferencedIgnoringLocallyDeletedEntities(IEntity entity) {
        return this.isReferencedInLocalDataIgnoringLocallyDeletedEntities(entity) || this.isReferencedInPersistedDataIgnoringLocallyDeletedEntities(entity);
    }

    @Override
    public boolean isReferencedInLocalDataIgnoringLocallyDeletedEntities(IEntity entity) {
        if (entity.belongsToDatabase()) {
            IContainer<? extends ITable<IEntity>> tables = ((IDatabase)entity.getStoredParentDatabase()).getStoredTables();
            for (ITable iTable : tables) {
                if (!iTable.internalGetStoredEntitiesInLocalData().containsAny(e -> !e.isDeleted() && this.referencesGivenEntity((IEntity)e, entity))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isReferencedInPersistedDataIgnoringLocallyDeletedEntities(IEntity entity) {
        if (entity.isReferencedInPersistedData()) {
            IContainer<String> locallyDeletedEntities = ENTITY_EXAMINER_HELPER.getLocallyDeletedEntitiesIds((IDatabase)entity.getStoredParentDatabase());
            return entity.isReferencedInPersistedDataIgnoringGivenEntities(locallyDeletedEntities);
        }
        return false;
    }

    @Override
    public boolean referencesGivenEntity(IEntity sourceEntity, IEntity entity) {
        return sourceEntity.internalGetStoredFields().containsAny(p -> p.referencesEntity(entity));
    }
}

