/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.ColumnMapper;
import ch.nolix.system.objectdata.model.Database;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.system.objectdata.model.TableMapper;
import ch.nolix.systemapi.midschema.fieldproperty.BaseFieldType;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.objectdata.model.IColumn;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;

public final class TableLoader {
    private TableLoader() {
    }

    public static LinkedList<Table<IEntity>> loadTablesForDatabase(Database database) {
        IContainer<TableDto> midTables = database.getStoredMidDataAdapterAndSchemaReader().loadTables();
        IContainer<Table<IEntity>> tables = midTables.to(rt -> TableMapper.mapMidSchemaTableDtoToTableWithoutColumns(rt, database));
        TableLoader.addBaseValueColumnsToTablesFromMidTables(tables, midTables);
        TableLoader.addBaseReferenceColumnsToTablesFromMidTables(tables, midTables, tables);
        TableLoader.addBaseBackReferenceColumnsToTablesFromMidTables(tables, midTables, tables);
        return LinkedList.fromIterable(tables);
    }

    private static void addBaseValueColumnsToTablesFromMidTables(IContainer<Table<IEntity>> tables, IContainer<TableDto> midTables) {
        for (Table table : tables) {
            String tableName = table.getName();
            TableDto midTable = midTables.getStoredFirst(rt -> rt.name().equals(tableName));
            TableLoader.addBaseValueColumnsToTableFromMidTable(table, midTable);
        }
    }

    private static void addBaseValueColumnsToTableFromMidTable(Table<IEntity> table, TableDto midTable) {
        IContainer<ColumnDto> midBaseValueColumnsView = midTable.columns().getViewOfStoredSelected(TableLoader::isBaseValue);
        for (ColumnDto c : midBaseValueColumnsView) {
            IColumn column = ColumnMapper.mapMidSchemaColumnDtoToColumn(c, table, ImmutableList.createEmpty());
            table.internalAddColumn(column);
        }
    }

    private static void addBaseReferenceColumnsToTablesFromMidTables(IContainer<Table<IEntity>> tables, IContainer<TableDto> midTables, IContainer<? extends ITable<IEntity>> referencableTables) {
        for (Table table : tables) {
            String tableName = table.getName();
            TableDto midTable = midTables.getStoredFirst(rt -> rt.name().equals(tableName));
            TableLoader.addBaseReferenceColumnsToTableFromMidTable(table, midTable, referencableTables);
        }
    }

    private static void addBaseReferenceColumnsToTableFromMidTable(Table<IEntity> table, TableDto midTable, IContainer<? extends ITable<IEntity>> referencableTables) {
        IContainer<ColumnDto> midBaseReferenceColumnsView = midTable.columns().getViewOfStoredSelected(TableLoader::isBaseReference);
        for (ColumnDto c : midBaseReferenceColumnsView) {
            IColumn column = ColumnMapper.mapMidSchemaColumnDtoToColumn(c, table, referencableTables);
            table.internalAddColumn(column);
        }
    }

    private static void addBaseBackReferenceColumnsToTablesFromMidTables(IContainer<Table<IEntity>> tables, IContainer<TableDto> midTables, IContainer<? extends ITable<IEntity>> referencableTables) {
        for (Table table : tables) {
            String tableName = table.getName();
            TableDto midTable = midTables.getStoredFirst(rt -> rt.name().equals(tableName));
            TableLoader.addBaseBackReferenceColumnsToTableFromMidTable(table, midTable, referencableTables);
        }
    }

    private static void addBaseBackReferenceColumnsToTableFromMidTable(Table<IEntity> table, TableDto midTable, IContainer<? extends ITable<IEntity>> referencableTables) {
        IContainer<ColumnDto> midBaseValueColumnsView = midTable.columns().getViewOfStoredSelected(TableLoader::isBaseBackReference);
        for (ColumnDto c : midBaseValueColumnsView) {
            IColumn column = ColumnMapper.mapMidSchemaColumnDtoToColumn(c, table, referencableTables);
            table.internalAddColumn(column);
        }
    }

    private static boolean isBaseBackReference(ColumnDto columnDto) {
        return columnDto.fieldType().getBaseType() == BaseFieldType.BASE_BACK_REFERENCE;
    }

    private static boolean isBaseReference(ColumnDto columnDto) {
        return columnDto.fieldType().getBaseType() == BaseFieldType.BASE_REFERENCE;
    }

    private static boolean isBaseValue(ColumnDto columnDto) {
        return columnDto.fieldType().getBaseType() == BaseFieldType.BASE_VALUE_FIELD;
    }
}

