/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.datastructure.property.LazyCalculatedProperty;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.objectdata.entitytool.EntityCreator;
import ch.nolix.system.objectdata.entitytool.EntityFiller;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.Database;
import ch.nolix.system.objectdata.model.EntityLoader;
import ch.nolix.system.objectdata.modelexaminer.EntityExaminer;
import ch.nolix.system.objectdata.modelexaminer.TableExaminer;
import ch.nolix.system.objectdata.modelsearcher.TableSearcher;
import ch.nolix.system.objectdata.modelvalidator.TableValidator;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.middata.model.EntityLoadingDto;
import ch.nolix.systemapi.objectdata.entitytool.IEntityCreator;
import ch.nolix.systemapi.objectdata.entitytool.IEntityFiller;
import ch.nolix.systemapi.objectdata.model.IColumn;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelexaminer.IEntityExaminer;
import ch.nolix.systemapi.objectdata.modelexaminer.ITableExaminer;
import ch.nolix.systemapi.objectdata.modelsearcher.ITableSearcher;
import java.util.Optional;

public final class Table<E extends IEntity>
implements ITable<E> {
    private static final TableValidator TABLE_VALIDATOR = new TableValidator();
    private static final ITableSearcher TABLE_TOOL = new TableSearcher();
    private static final ITableExaminer TABLE_EXAMINER = new TableExaminer();
    private static final IEntityCreator ENTITY_CREATOR = new EntityCreator();
    private static final IEntityExaminer ENTITY_EXAMINER = new EntityExaminer();
    private static final IEntityFiller ENTITY_FILLER = new EntityFiller();
    private final Database parentDatabase;
    private final String name;
    private final String memberId;
    private final Class<E> entityClass;
    private final LazyCalculatedProperty<IContainer<IColumn>> columnsThatReferenceCurrentTable = LazyCalculatedProperty.forValueCreater(() -> TABLE_TOOL.getStoredColumsThatReferencesTable(this));
    private boolean loadedAllEntitiesInLocalData;
    private final ILinkedList<IColumn> memberColumns = LinkedList.createEmpty();
    private final ILinkedList<E> entitiesInLocalData = LinkedList.createEmpty();

    private Table(Database parentDatabase, String name, String id, Class<E> entityClass) {
        Validator.assertThat(parentDatabase).thatIsNamed("parent Database").isNotNull();
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        Validator.assertThat(entityClass).thatIsNamed("entity class").isNotNull();
        this.parentDatabase = parentDatabase;
        this.name = name;
        this.memberId = id;
        this.entityClass = entityClass;
    }

    static <T extends IEntity> Table<T> withParentDatabaseAndNameAndIdAndEntityType(Database parentDatabase, String name, String id, Class<T> entityType) {
        return new Table<T>(parentDatabase, name, id, entityType);
    }

    @Override
    public boolean belongsToDatabase() {
        return true;
    }

    @Override
    public boolean containsEntityWithId(String id) {
        return this.getStoredMidDataDataAdapterAndSchemaReader().tableContainsEntity(this.getName(), id);
    }

    @Override
    public int getEntityCount() {
        int entityCount = this.getStoredMidDataDataAdapterAndSchemaReader().getEntityCount(this.getName());
        for (IEntity e : this.internalGetStoredEntitiesInLocalData()) {
            if (e.isNew()) {
                ++entityCount;
                continue;
            }
            if (!e.isDeleted()) continue;
            --entityCount;
        }
        return entityCount;
    }

    @Override
    public Class<E> getEntityType() {
        return this.entityClass;
    }

    @Override
    public String getId() {
        return this.memberId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<E> getOptionalStoredEntityById(String id) {
        Optional<IEntity> entity = this.internalGetStoredEntitiesInLocalData().getOptionalStoredFirst(e -> e.hasId(id));
        if (entity.isEmpty()) {
            if (this.getStoredMidDataDataAdapterAndSchemaReader().tableContainsEntity(this.getName(), id)) {
                this.addEntityWithIdWhenIsNotAdded(id);
                return Optional.of(this.getStoredEntityByIdWhenIsInLocalData(id));
            }
            return Optional.empty();
        }
        return entity;
    }

    @Override
    public IContainer<IColumn> getStoredColumns() {
        return this.memberColumns;
    }

    @Override
    public IContainer<E> getStoredEntities() {
        this.loadAllEntitiesInLocalDataIfNotLoaded();
        return this.entitiesInLocalData;
    }

    @Override
    public E getStoredEntityById(String id) {
        Optional<IEntity> entity = this.internalGetStoredEntitiesInLocalData().getOptionalStoredFirst(e -> e.hasId(id));
        if (entity.isEmpty()) {
            this.addEntityWithIdWhenIsNotAdded(id);
            return this.getStoredEntityByIdWhenIsInLocalData(id);
        }
        return (E)entity.get();
    }

    @Override
    public IDatabase getStoredParentDatabase() {
        return this.parentDatabase;
    }

    @Override
    public DatabaseObjectState getState() {
        if (this.parentDatabase.isClosed()) {
            return DatabaseObjectState.CLOSED;
        }
        if (this.internalGetStoredEntitiesInLocalData().containsAny(ENTITY_EXAMINER::isNewOrEditedOrDeleted)) {
            return DatabaseObjectState.EDITED;
        }
        return DatabaseObjectState.UNEDITED;
    }

    @Override
    public ITable<E> insertEntity(E entity) {
        entity.internalSetParentTable(this);
        TABLE_VALIDATOR.assertCanInsertEntity(this, (IEntity)entity);
        this.executeInsertEntity(entity);
        return this;
    }

    @Override
    public boolean isClosed() {
        return this.parentDatabase.isClosed();
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public boolean isEdited() {
        return this.getState() == DatabaseObjectState.EDITED;
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.parentDatabase.isConnectedWithRealDatabase();
    }

    @Override
    public boolean isLoaded() {
        return this.getState() == DatabaseObjectState.UNEDITED;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public IContainer<E> internalGetStoredEntitiesInLocalData() {
        return this.entitiesInLocalData;
    }

    void close() {
        for (IEntity e : this.internalGetStoredEntitiesInLocalData()) {
            ((AbstractEntity)e).close();
        }
    }

    IDataAdapterAndSchemaReader getStoredMidDataDataAdapterAndSchemaReader() {
        return this.parentDatabase.getStoredMidDataAdapterAndSchemaReader();
    }

    void internalAddColumn(IColumn column) {
        this.memberColumns.addAtEnd(column);
    }

    IContainer<IColumn> internalGetColumnsThatReferencesCurrentTable() {
        return this.columnsThatReferenceCurrentTable.getStoredValue();
    }

    void internalSetColumns(IContainer<IColumn> columns) {
        this.memberColumns.clear();
        this.memberColumns.addAtEnd(columns);
    }

    private void addEntityWithIdWhenIsNotAdded(String id) {
        Object entity = EntityLoader.loadEntityById(this, id, this.getStoredMidDataDataAdapterAndSchemaReader());
        this.entitiesInLocalData.addAtEnd(entity);
    }

    private void executeInsertEntity(E entity) {
        this.entitiesInLocalData.addAtEnd(entity);
        ((AbstractEntity)entity).noteInsertIntoDatabase();
    }

    private E getStoredEntityByIdWhenIsInLocalData(String id) {
        return (E)this.internalGetStoredEntitiesInLocalData().getStoredFirst(e -> e.hasId(id));
    }

    private void insertEntityFromGivenLoadedEntityDtoInLocalDataIfNotInserted(EntityLoadingDto loadedEntity) {
        if (!TABLE_EXAMINER.containsEntityWithGivenIdInLocalData(this, loadedEntity.id())) {
            E entity = ENTITY_CREATOR.createEmptyEntityForEntityType(this.getEntityType());
            entity.internalSetParentTable(this);
            ENTITY_FILLER.fillUpEntityFromEntityLoadingDto((IEntity)entity, loadedEntity);
            this.entitiesInLocalData.addAtEnd(entity);
        }
    }

    private void loadAllEntitiesInLocalDataIfNotLoaded() {
        if (!this.loadedAllEntitiesInLocalData()) {
            this.loadAllEntitiesInLocalDataWhenNotLoadedAll();
        }
    }

    private void loadAllEntitiesInLocalDataWhenNotLoadedAll() {
        for (EntityLoadingDto r : this.getStoredMidDataDataAdapterAndSchemaReader().loadEntities(this.getName())) {
            this.insertEntityFromGivenLoadedEntityDtoInLocalDataIfNotInserted(r);
        }
        this.loadedAllEntitiesInLocalData = true;
    }

    private boolean loadedAllEntitiesInLocalData() {
        return this.loadedAllEntitiesInLocalData;
    }
}

