/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.entitytool.EntityCreator;
import ch.nolix.system.objectdata.schemamapper.ColumnMapper;
import ch.nolix.system.objectdata.schemamapper.TableMapper;
import ch.nolix.system.objectdata.schemasearcher.SchemaSearcher;
import ch.nolix.systemapi.midschema.fieldproperty.BaseFieldType;
import ch.nolix.systemapi.objectdata.entitytool.IEntityCreator;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IEntityTypeSet;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.schemamapper.IColumnMapper;
import ch.nolix.systemapi.objectdata.schemamapper.ITableMapper;
import ch.nolix.systemapi.objectdata.schemamodelsearcher.ISchemaSearcher;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.schemaadapter.ISchemaAdapter;

public final class SchemaInitializer {
    private static final ISchemaSearcher SCHEMA_SEARCHER = new SchemaSearcher();
    private static final ITableMapper TABLE_MAPPER = new TableMapper();
    private static final IEntityCreator ENTITY_CREATOR = new EntityCreator();
    private static final IColumnMapper COLUMN_MAPPER = new ColumnMapper();

    private SchemaInitializer() {
    }

    public static void initializeDatabaseIfDatabaseIsEmpty(IEntityTypeSet entityTypeSet, ISchemaAdapter schemaAdapter) {
        if (schemaAdapter.databaseIsEmpty()) {
            SchemaInitializer.initializeDatabase(entityTypeSet, schemaAdapter);
        }
    }

    private static void initializeDatabase(IEntityTypeSet entityTypeSet, ISchemaAdapter schemaAdapter) {
        IContainer<ITable> tables = TABLE_MAPPER.mapSchemaToEmptyTables(entityTypeSet);
        tables.forEach(schemaAdapter::addTable);
        SchemaInitializer.addBaseValueColumnsToTables(tables, entityTypeSet);
        SchemaInitializer.addBaseReferenceColumnsToTables(tables, entityTypeSet, tables);
        SchemaInitializer.addBaseBackReferenceColumnsToTables(tables, entityTypeSet, tables);
        schemaAdapter.saveChanges();
    }

    private static void addBaseValueColumnsToTables(IContainer<ITable> tables, IEntityTypeSet entityTypeSet) {
        for (ITable t : tables) {
            Class<? extends IEntity> entityType = SCHEMA_SEARCHER.getEntityTypeByName(entityTypeSet, t.getName());
            SchemaInitializer.addBaseValueColumnsToTable(t, entityType);
        }
    }

    private static void addBaseValueColumnsToTable(ITable table, Class<? extends IEntity> entityType) {
        IEntity entity = ENTITY_CREATOR.createEmptyEntityForEntityType(entityType);
        IContainer<IField> baseValuesView = entity.internalGetStoredFields().getViewOfStoredSelected(p -> p.getType().getBaseType() == BaseFieldType.BASE_VALUE_FIELD);
        for (IField v : baseValuesView) {
            IColumn column = COLUMN_MAPPER.mapFieldToColumn(v, ImmutableList.createEmpty());
            table.addColumn(column);
        }
    }

    private static void addBaseReferenceColumnsToTables(IContainer<ITable> tables, IEntityTypeSet entityTypeSet, IContainer<ITable> referencableTables) {
        for (ITable t : tables) {
            Class<? extends IEntity> entityType = SCHEMA_SEARCHER.getEntityTypeByName(entityTypeSet, t.getName());
            SchemaInitializer.addBaseReferenceColumnsToTable(t, entityType, referencableTables);
        }
    }

    private static void addBaseReferenceColumnsToTable(ITable table, Class<? extends IEntity> entityType, IContainer<ITable> referencableTables) {
        IEntity entity = ENTITY_CREATOR.createEmptyEntityForEntityType(entityType);
        IContainer<IField> baseReferencesView = entity.internalGetStoredFields().getViewOfStoredSelected(p -> p.getType().getBaseType() == BaseFieldType.BASE_REFERENCE);
        for (IField r : baseReferencesView) {
            IColumn column = COLUMN_MAPPER.mapFieldToColumn(r, referencableTables);
            table.addColumn(column);
        }
    }

    private static void addBaseBackReferenceColumnsToTables(IContainer<ITable> tables, IEntityTypeSet entityTypeSet, IContainer<ITable> referencableTables) {
        for (ITable t : tables) {
            Class<? extends IEntity> entityType = SCHEMA_SEARCHER.getEntityTypeByName(entityTypeSet, t.getName());
            SchemaInitializer.addBaseBackReferenceColumnsToTable(t, entityType, referencableTables);
        }
    }

    private static void addBaseBackReferenceColumnsToTable(ITable table, Class<? extends IEntity> entityType, IContainer<ITable> referencableTables) {
        IEntity entity = ENTITY_CREATOR.createEmptyEntityForEntityType(entityType);
        IContainer<IField> baseBackReferencesView = entity.internalGetStoredFields().getViewOfStoredSelected(p -> p.getType().getBaseType() == BaseFieldType.BASE_BACK_REFERENCE);
        for (IField b : baseBackReferencesView) {
            IColumn column = COLUMN_MAPPER.mapFieldToColumn(b, referencableTables);
            table.addColumn(column);
        }
    }
}

