/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.databaseobject.modelvalidator.DatabaseObjectValidator;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.objectdata.model.IMultiValueField;
import ch.nolix.systemapi.objectdata.model.IMultiValueFieldEntry;

public final class MultiValueFieldEntry<V>
implements IMultiValueFieldEntry<V> {
    private static final DatabaseObjectValidator DATABASE_OBJECT_VALIDATOR = new DatabaseObjectValidator();
    private final IMultiValueField<V> parentMultiValue;
    private DatabaseObjectState state;
    private final V value;

    private MultiValueFieldEntry(IMultiValueField<V> parentMultiValue, DatabaseObjectState initialState, V value) {
        Validator.assertThat(parentMultiValue).thatIsNamed("parent MultiValue").isNotNull();
        Validator.assertThat(initialState).thatIsNamed("initial state").isNotNull();
        Validator.assertThat(value).thatIsNamed("value").isNotNull();
        this.parentMultiValue = parentMultiValue;
        this.state = initialState;
        this.value = value;
    }

    public static <V2> MultiValueFieldEntry<V2> loadedEntryForMultiValueAndValue(IMultiValueField<V2> multiValue, V2 value) {
        return new MultiValueFieldEntry<V2>(multiValue, DatabaseObjectState.UNEDITED, value);
    }

    public static <V2> MultiValueFieldEntry<V2> newEntryForMultiValueAndValue(IMultiValueField<V2> multiValue, V2 value) {
        return new MultiValueFieldEntry<V2>(multiValue, DatabaseObjectState.NEW, value);
    }

    @Override
    public IMultiValueField<V> getStoredParentMultiValue() {
        return this.parentMultiValue;
    }

    @Override
    public V getStoredValue() {
        return this.value;
    }

    @Override
    public DatabaseObjectState getState() {
        return switch ((DatabaseObjectState)((Object)this.getStoredParentMultiValue().getState())) {
            case DatabaseObjectState.DELETED -> DatabaseObjectState.DELETED;
            case DatabaseObjectState.CLOSED -> DatabaseObjectState.CLOSED;
            default -> this.state;
        };
    }

    @Override
    public boolean isClosed() {
        return this.getStoredParentMultiValue().isClosed();
    }

    @Override
    public boolean isDeleted() {
        return this.getStoredParentMultiValue().isDeleted();
    }

    @Override
    public boolean isEdited() {
        return this.getState() == DatabaseObjectState.EDITED;
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.getStoredParentMultiValue().isConnectedWithRealDatabase();
    }

    @Override
    public boolean isLoaded() {
        return this.getState() == DatabaseObjectState.UNEDITED;
    }

    @Override
    public boolean isNew() {
        return this.getState() == DatabaseObjectState.NEW;
    }

    void internalSetDeleted() {
        this.assertIsLoaded();
        this.state = DatabaseObjectState.DELETED;
    }

    private void assertIsLoaded() {
        DATABASE_OBJECT_VALIDATOR.assertIsLoaded(this);
    }
}

