/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.databaseobject.modelvalidator.DatabaseObjectValidator;
import ch.nolix.system.objectdata.modelsearcher.DatabaseSearcher;
import ch.nolix.systemapi.databaseobject.modelvalidator.IDatabaseObjectValidator;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiBackReferenceEntry;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelsearcher.IDatabaseSearcher;
import ch.nolix.systemapi.objectdata.structure.EntityCache;

public final class MultiBackReferenceEntry<E extends IEntity>
implements IMultiBackReferenceEntry<E> {
    private static final IDatabaseObjectValidator DATABASE_OBJECT_VALIDATOR = new DatabaseObjectValidator();
    private static final IDatabaseSearcher DATABASE_SEARCHER = new DatabaseSearcher();
    private final IMultiBackReference<E> parentMultiBackReference;
    private DatabaseObjectState state;
    private EntityCache<E> backReferencedEntityCache;

    private MultiBackReferenceEntry(IMultiBackReference<E> parentMultiBackReference, DatabaseObjectState initialState, E backReferencedEntity) {
        Validator.assertThat(parentMultiBackReference).thatIsNamed("parent MultiBackReference").isNotNull();
        Validator.assertThat(initialState).thatIsNamed("initial state").isNotNull();
        Validator.assertThat(backReferencedEntity).thatIsNamed("back referenced entity").isNotNull();
        String backReferencedEntityId = backReferencedEntity.getId();
        this.parentMultiBackReference = parentMultiBackReference;
        this.state = initialState;
        this.backReferencedEntityCache = new EntityCache<E>(backReferencedEntityId, null, backReferencedEntity);
    }

    private MultiBackReferenceEntry(IMultiBackReference<E> parentMultiBackReference, DatabaseObjectState initialState, String backReferencedEntityId, String backReferencedTableId) {
        Validator.assertThat(parentMultiBackReference).thatIsNamed("parent MultiBackReference").isNotNull();
        Validator.assertThat(initialState).thatIsNamed("initial state").isNotNull();
        Validator.assertThat(backReferencedEntityId).thatIsNamed("back referenced entity id").isNotBlank();
        Validator.assertThat(backReferencedTableId).thatIsNamed("back referenced table id").isNotBlank();
        this.parentMultiBackReference = parentMultiBackReference;
        this.state = initialState;
        this.backReferencedEntityCache = new EntityCache<Object>(backReferencedEntityId, backReferencedTableId, null);
    }

    public static <T extends IEntity> MultiBackReferenceEntry<T> createLoadedEntryForMultiBackReferenceAndBackReferencedEntityIdAndBackReferencedTableId(IMultiBackReference<T> multiBackReference, String backReferencedEntityId, String backReferencedTableId) {
        return new MultiBackReferenceEntry<T>(multiBackReference, DatabaseObjectState.UNEDITED, backReferencedEntityId, backReferencedTableId);
    }

    public static <T extends IEntity> MultiBackReferenceEntry<T> createNewEntryForMultiBackReferenceAndBackReferencedEntityIdAndBackReferencedTableId(IMultiBackReference<T> multiBackReference, String backReferencedEntityId, String backReferencedTableId) {
        return new MultiBackReferenceEntry<T>(multiBackReference, DatabaseObjectState.NEW, backReferencedEntityId, backReferencedTableId);
    }

    public static <T extends IEntity> MultiBackReferenceEntry<T> createNewEntryForMultiBackReferenceAndBackReferencedEntity(IMultiBackReference<T> multiBackReference, T backReferencedEntity) {
        return new MultiBackReferenceEntry<T>(multiBackReference, DatabaseObjectState.NEW, backReferencedEntity);
    }

    @Override
    public boolean belongsToDatabase() {
        return this.getStoredParentMultiBackReference().belongsToDatabase();
    }

    @Override
    public boolean belongsToTable() {
        return this.getStoredParentMultiBackReference().belongsToTable();
    }

    @Override
    public String getBackReferencedEntityId() {
        return this.backReferencedEntityCache.entityId();
    }

    @Override
    public String getBackReferencedTableId() {
        this.retrieveBackReferencedTableId();
        return this.backReferencedEntityCache.nullableTableId();
    }

    @Override
    public DatabaseObjectState getState() {
        return switch ((DatabaseObjectState)((Object)this.getStoredParentMultiBackReference().getState())) {
            case DatabaseObjectState.NEW -> DatabaseObjectState.NEW;
            case DatabaseObjectState.DELETED -> DatabaseObjectState.DELETED;
            case DatabaseObjectState.CLOSED -> DatabaseObjectState.CLOSED;
            default -> this.state;
        };
    }

    @Override
    public E getStoredBackReferencedEntity() {
        this.retrieveBackReferencedEntity();
        return (E)((IEntity)this.backReferencedEntityCache.nullableEntity());
    }

    @Override
    public ITable<E> getStoredBackReferencedTable() {
        IEntity backReferencedEntity = (IEntity)this.backReferencedEntityCache.nullableEntity();
        if (backReferencedEntity != null && backReferencedEntity.belongsToTable()) {
            return (ITable)backReferencedEntity.getStoredParentTable();
        }
        if (this.belongsToDatabase()) {
            IDatabase database = (IDatabase)this.getStoredParentMultiBackReference().getStoredParentDatabase();
            return DATABASE_SEARCHER.getStoredTableById(database, this.getBackReferencedTableId());
        }
        IDatabase database = (IDatabase)((IEntity)this.backReferencedEntityCache.nullableEntity()).getStoredParentDatabase();
        return DATABASE_SEARCHER.getStoredTableById(database, this.getBackReferencedTableId());
    }

    @Override
    public IDatabase getStoredParentDatabase() {
        return (IDatabase)this.getStoredParentTable().getStoredParentDatabase();
    }

    @Override
    public IMultiBackReference<E> getStoredParentMultiBackReference() {
        return this.parentMultiBackReference;
    }

    @Override
    public ITable<? extends IEntity> getStoredParentTable() {
        return (ITable)this.getStoredParentMultiBackReference().getStoredParentTable();
    }

    @Override
    public boolean isClosed() {
        return this.getStoredParentMultiBackReference().isClosed();
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.getStoredParentMultiBackReference().isConnectedWithRealDatabase();
    }

    @Override
    public boolean isDeleted() {
        return this.getStoredParentMultiBackReference().isDeleted();
    }

    @Override
    public boolean isEdited() {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.getState() == DatabaseObjectState.UNEDITED;
    }

    @Override
    public boolean isNew() {
        return this.getState() == DatabaseObjectState.NEW;
    }

    void setDeleted() {
        DATABASE_OBJECT_VALIDATOR.assertIsLoaded(this);
        this.state = DatabaseObjectState.DELETED;
    }

    private void retrieveBackReferencedEntity() {
        IEntity backReferencedEntity = (IEntity)this.backReferencedEntityCache.nullableEntity();
        if (backReferencedEntity == null) {
            String backReferencedEntityId = this.backReferencedEntityCache.entityId();
            String backReferencedTableId = this.backReferencedEntityCache.nullableTableId();
            backReferencedEntity = this.getStoredBackReferencedTable().getStoredEntityById(backReferencedEntityId);
            this.backReferencedEntityCache = new EntityCache<IEntity>(backReferencedEntityId, backReferencedTableId, backReferencedEntity);
        }
    }

    private void retrieveBackReferencedTableId() {
        String backReferencedTableId = this.backReferencedEntityCache.nullableTableId();
        if (backReferencedTableId == null) {
            String backReferencedEntityId = this.backReferencedEntityCache.entityId();
            IEntity backReferencedEntity = (IEntity)this.backReferencedEntityCache.nullableEntity();
            backReferencedTableId = ((ITable)backReferencedEntity.getStoredParentTable()).getId();
            this.backReferencedEntityCache = new EntityCache<IEntity>(backReferencedEntityId, backReferencedTableId, backReferencedEntity);
        }
    }
}

