/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.MultiBackReference;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class BaseBackReferenceUpdater {
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();

    private BaseBackReferenceUpdater() {
    }

    public static void updateBaseBackReferenceForClearBaseReference(IBaseBackReference baseBackReference, String backReferencedEntityId) {
        IBaseBackReference iBaseBackReference = baseBackReference;
        Objects.requireNonNull(iBaseBackReference);
        IBaseBackReference iBaseBackReference2 = iBaseBackReference;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BackReference.class, OptionalBackReference.class, MultiBackReference.class}, (Object)iBaseBackReference2, 0)) {
            case 0: {
                BackReference backReference = (BackReference)iBaseBackReference2;
                backReference.clear();
                break;
            }
            case 1: {
                OptionalBackReference optionalBackReference = (OptionalBackReference)iBaseBackReference2;
                optionalBackReference.clear();
                break;
            }
            case 2: {
                MultiBackReference multiBackReference = (MultiBackReference)iBaseBackReference2;
                multiBackReference.deleteEntryByBackReferencedEntityId(backReferencedEntityId);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument(baseBackReference);
            }
        }
    }

    public static void updateBaseBackReferenceThatReferencesBackEntityForDeleteEntity(IBaseBackReference baseBackReference, IEntity entity) {
        IBaseBackReference iBaseBackReference = baseBackReference;
        Objects.requireNonNull(iBaseBackReference);
        IBaseBackReference iBaseBackReference2 = iBaseBackReference;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BackReference.class, OptionalBackReference.class, MultiBackReference.class}, (Object)iBaseBackReference2, 0)) {
            case 0: {
                BackReference backReference = (BackReference)iBaseBackReference2;
                backReference.clear();
                break;
            }
            case 1: {
                OptionalBackReference optionalBackReference = (OptionalBackReference)iBaseBackReference2;
                optionalBackReference.clear();
                break;
            }
            case 2: {
                MultiBackReference multiBackReference = (MultiBackReference)iBaseBackReference2;
                String backReferencedEntityId = entity.getId();
                multiBackReference.deleteEntryByBackReferencedEntityId(backReferencedEntityId);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument(baseBackReference);
            }
        }
    }

    public static void updateBaseBackReferencesThatReferencesBackEntityForDeleteEntity(IEntity entity) {
        IContainer<IBaseBackReference> baseBackReferences = ENTITY_SEARCHER.getStoredBaseBackReferencesThatReferenceBackEntity(entity);
        for (IBaseBackReference b : baseBackReferences) {
            BaseBackReferenceUpdater.updateBaseBackReferenceThatReferencesBackEntityForDeleteEntity(b, entity);
        }
    }
}

