/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.middatamodelmapper;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.middatamodelmapper.StringRepresentedFieldDtoMapperHelper;
import ch.nolix.systemapi.middata.model.ValueStringFieldDto;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IStringRepresentedFieldDtoMapper;
import ch.nolix.systemapi.objectdata.model.IBackReference;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiReference;
import ch.nolix.systemapi.objectdata.model.IMultiValueField;
import ch.nolix.systemapi.objectdata.model.IOptionalBackReference;
import ch.nolix.systemapi.objectdata.model.IOptionalReference;
import ch.nolix.systemapi.objectdata.model.IOptionalValueField;
import ch.nolix.systemapi.objectdata.model.IReference;
import ch.nolix.systemapi.objectdata.model.IValueField;

public final class StringRepresentedFieldDtoMapper
implements IStringRepresentedFieldDtoMapper {
    @Override
    public IContainer<ValueStringFieldDto> mapFieldsToStringRepresentedFieldDtos(IContainer<? extends IField> fields) {
        return fields.to(this::mapFieldToStringRepresentedFieldDto);
    }

    @Override
    public ValueStringFieldDto mapFieldToStringRepresentedFieldDto(IField field) {
        if (field instanceof IValueField) {
            IValueField value = (IValueField)field;
            return new ValueStringFieldDto(value.getName(), value.getStoredValue().toString(), null);
        }
        if (field instanceof IOptionalValueField) {
            IOptionalValueField optionalValue = (IOptionalValueField)field;
            return StringRepresentedFieldDtoMapperHelper.mapOptionalValueToStringContentFieldDto(optionalValue);
        }
        if (field instanceof IMultiValueField) {
            IMultiValueField multiValue = (IMultiValueField)field;
            return new ValueStringFieldDto(multiValue.getName(), null, null);
        }
        if (field instanceof IReference) {
            IReference reference = (IReference)field;
            return new ValueStringFieldDto(reference.getName(), reference.getReferencedEntityId(), reference.getReferencedTableId());
        }
        if (field instanceof IOptionalReference) {
            IOptionalReference optionalReference = (IOptionalReference)field;
            return StringRepresentedFieldDtoMapperHelper.mapOptionalReferenceToStringContentFieldDto(optionalReference);
        }
        if (field instanceof IMultiReference) {
            IMultiReference multiReference = (IMultiReference)field;
            return new ValueStringFieldDto(multiReference.getName(), null, null);
        }
        if (field instanceof IBackReference) {
            IBackReference backReference = (IBackReference)field;
            return new ValueStringFieldDto(backReference.getName(), backReference.getBackReferencedEntityId(), backReference.getBackReferencedTableId());
        }
        if (field instanceof IOptionalBackReference) {
            IOptionalBackReference optionalBackReference = (IOptionalBackReference)field;
            return StringRepresentedFieldDtoMapperHelper.mapOptionalBackReferenceToStringContentFieldDto(optionalBackReference);
        }
        if (field instanceof IMultiBackReference) {
            IMultiBackReference multiBackReference = (IMultiBackReference)field;
            return new ValueStringFieldDto(multiBackReference.getName(), null, null);
        }
        throw InvalidArgumentException.forArgument(field);
    }
}

