/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.fieldexaminer;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.cardinality.BaseCardinality;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.systemapi.objectdata.fieldexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IBaseReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;

public class FieldExaminer
extends DatabaseObjectExaminer
implements IFieldExaminer {
    @Override
    public boolean belongsToEntity(IField field) {
        return field != null && field.belongsToEntity();
    }

    @Override
    public boolean belongsToLoadedEntity(IField field) {
        return this.belongsToEntity(field) && ((IEntity)field.getStoredParentEntity()).isLoaded();
    }

    @Override
    public boolean canReferenceBackBaseReference(IField field, IBaseReference baseReference) {
        if (field instanceof IBaseBackReference) {
            IBaseBackReference baseBackReference = (IBaseBackReference)field;
            if (baseReference != null && baseReference.belongsToEntity()) {
                String baseReferenceParentTableName = ((IEntity)baseReference.getStoredParentEntity()).getParentTableName();
                String baseReferenceName = baseReference.getName();
                IContainer<String> backReferenceableTableNames = baseBackReference.getBackReferenceableTableNames();
                String backReferencedFieldName = baseBackReference.getBackReferencedFieldName();
                return backReferenceableTableNames.contains(baseReferenceParentTableName) && backReferencedFieldName.equals(baseReferenceName);
            }
        }
        return false;
    }

    @Override
    public boolean isForMultiContent(IField field) {
        return field != null && field.getType().getCardinality().getBaseCardinality() == BaseCardinality.MULTI;
    }

    @Override
    public boolean isForSingleContent(IField field) {
        return field != null && field.getType().getCardinality().getBaseCardinality() == BaseCardinality.SINGLE;
    }

    @Override
    public boolean isMandatoryButEmpty(IField field) {
        return field != null && field.isMandatory() && field.isEmpty();
    }

    @Override
    public boolean isSetForCaseWhenIsMandatoryAndNewOrEdited(IField field) {
        return field != null && (!field.isMandatory() || !this.isNewOrEdited(field) || field.containsAny());
    }
}

