/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.adapter;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.resourcecontrol.closecontroller.GroupCloseable;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.system.objectdata.model.Database;
import ch.nolix.system.objectdata.model.SchemaInitializer;
import ch.nolix.system.objectdata.persistence.DatabasePersister;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.objectdata.adapter.IDataAdapter;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IEntityTypeSet;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.perstistence.IDatabasePersister;
import ch.nolix.systemapi.objectschema.schemaadapter.ISchemaAdapter;
import java.util.function.Supplier;

public abstract class AbstractDataAdapter
implements IDataAdapter {
    private static final IDatabasePersister DATABASE_PERSISTER = new DatabasePersister();
    private final String databaseName;
    private final IEntityTypeSet entityTypeSet;
    private final ICloseController closeController = CloseController.forElement(this);
    private int saveCount;
    private Database database;
    private IDataAdapterAndSchemaReader midDataAdapterAndSchemaReader;

    protected AbstractDataAdapter(String databaseName, IEntityTypeSet entityTypeSet, ISchemaAdapter schemaAdapter, Supplier<IDataAdapterAndSchemaReader> midDataAdapterAndSchemaReader) {
        Validator.assertThat(databaseName).thatIsNamed("database name").isNotBlank();
        SchemaInitializer.initializeDatabaseIfDatabaseIsEmpty(entityTypeSet, schemaAdapter);
        schemaAdapter.close();
        this.midDataAdapterAndSchemaReader = midDataAdapterAndSchemaReader.get();
        this.databaseName = databaseName;
        this.entityTypeSet = entityTypeSet;
        this.database = Database.withEntityTypeSetAndMidDataAdapterAndSchemaReader(entityTypeSet, (IDataAdapterAndSchemaReader)this.midDataAdapterAndSchemaReader.createEmptyCopy());
        this.createCloseDependencyTo(this.midDataAdapterAndSchemaReader);
    }

    @Override
    public final void createCloseDependencyTo(GroupCloseable element) {
        IDataAdapter.super.createCloseDependencyTo(element);
    }

    @Override
    public final String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public final int getSaveCount() {
        return this.saveCount;
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public final <E extends IEntity> ITable<E> getStoredTableByEntityType(Class<E> entityType) {
        return this.database.getStoredTableByEntityType(entityType);
    }

    @Override
    public final boolean hasChanges() {
        return this.database.isEdited();
    }

    @Override
    public final IDataAdapter insertEntity(IEntity entity) {
        this.database.insertEntity(entity);
        return this;
    }

    @Override
    public final void noteClose() {
        this.database.close();
    }

    @Override
    public final synchronized void reset() {
        this.database.close();
        this.midDataAdapterAndSchemaReader = (IDataAdapterAndSchemaReader)this.midDataAdapterAndSchemaReader.createEmptyCopy();
        this.database = Database.withEntityTypeSetAndMidDataAdapterAndSchemaReader(this.entityTypeSet, this.midDataAdapterAndSchemaReader);
    }

    @Override
    public final synchronized void saveChanges() {
        try {
            this.saveChangesAndIncrementSaveCount();
        }
        finally {
            this.reset();
        }
    }

    protected final IEntityTypeSet getSchema() {
        return this.entityTypeSet;
    }

    private synchronized void saveChangesAndIncrementSaveCount() {
        DATABASE_PERSISTER.persistDatabaseChangesTransactional(this.database, this.midDataAdapterAndSchemaReader);
        ++this.saveCount;
    }
}

