/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemidschema.schemareader;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.system.nodemidschema.modelmapper.ColumnDtoMapper;
import ch.nolix.system.nodemidschema.nodesearcher.TableNodeSearcher;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.nodemidschema.modelmapper.IColumnDtoMapper;
import ch.nolix.systemapi.nodemidschema.nodesearcher.ITableNodeSearcher;
import ch.nolix.systemapi.nodemidschema.schemareader.ISchemaReaderHelper;

public final class SchemaReaderHelper
implements ISchemaReaderHelper {
    private static final ITableNodeSearcher TABLE_NODE_SEARCHER = new TableNodeSearcher();
    private static final IColumnDtoMapper COLUMN_DTO_MAPPER = new ColumnDtoMapper();

    @Override
    public IContainer<ColumnDto> loadColumnsFromTableNode(IMutableNode<?> tableNode) {
        IContainer<IMutableNode<?>> columnNodes = TABLE_NODE_SEARCHER.getStoredColumnNodesFromTableNode(tableNode);
        return columnNodes.to(COLUMN_DTO_MAPPER::mapColumnNodeToColumnDto);
    }

    @Override
    public TableDto loadTableFromTableNode(IMutableNode<?> tableNode) {
        String tableId = TABLE_NODE_SEARCHER.getTableIdFromTableNode(tableNode);
        String tableName = TABLE_NODE_SEARCHER.getTableNameFromTableNode(tableNode);
        IContainer<ColumnDto> columns = this.loadColumnsFromTableNode(tableNode);
        return new TableDto(tableId, tableName, columns);
    }
}

