/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemidschema.schemareader;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.system.nodemidschema.nodeexaminer.TableNodeExaminer;
import ch.nolix.system.nodemidschema.nodesearcher.DatabaseNodeSearcher;
import ch.nolix.system.nodemidschema.nodesearcher.DatabasePropertiesNodeSearcher;
import ch.nolix.system.nodemidschema.schemareader.SchemaReaderHelper;
import ch.nolix.system.time.moment.Time;
import ch.nolix.systemapi.midschema.adapter.ISchemaReader;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.nodemidschema.nodeexaminer.ITableNodeExaminer;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IDatabaseNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IDatabasePropertiesNodeSearcher;
import ch.nolix.systemapi.nodemidschema.schemareader.ISchemaReaderHelper;

public final class SchemaReader
implements ISchemaReader {
    private static final ISchemaReaderHelper SCHEMA_READER_HELPER = new SchemaReaderHelper();
    private static final IDatabaseNodeSearcher DATABASE_NODE_SEARCHER = new DatabaseNodeSearcher();
    private static final IDatabasePropertiesNodeSearcher DATABASE_PROPERTIES_NODE_SEARCHER = new DatabasePropertiesNodeSearcher();
    private static final ITableNodeExaminer TABLE_NODE_EXAMINER = new TableNodeExaminer();
    private final ICloseController closeController = CloseController.forElement(this);
    private final IMutableNode<?> nodeDatabase;

    private SchemaReader(IMutableNode<?> nodeDatabase) {
        Validator.assertThat(nodeDatabase).thatIsNamed("node database").isNotNull();
        this.nodeDatabase = nodeDatabase;
    }

    public static SchemaReader forNodeDatabase(IMutableNode<?> nodeDatabase) {
        return new SchemaReader(nodeDatabase);
    }

    @Override
    public boolean columnIsEmpty(String tableName, String columnName) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableName);
        return TABLE_NODE_EXAMINER.columnOfTableNodeIsEmptyByColumnName(tableNode, columnName);
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public int getTableCount() {
        return DATABASE_NODE_SEARCHER.getTableNodeCount(this.nodeDatabase);
    }

    @Override
    public Time getSchemaTimestamp() {
        IMutableNode<?> databasePropertiesNode = DATABASE_NODE_SEARCHER.getStoredDatabasePropertiesNodeFromNodeDatabase(this.nodeDatabase);
        IMutableNode<?> timestampNode = DATABASE_PROPERTIES_NODE_SEARCHER.getStoredSchemaTimestampNodeFromDatabasePropertiesNode(databasePropertiesNode);
        return Time.fromSpecification(timestampNode);
    }

    @Override
    public TableDto loadTable(String tableName) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableName);
        return SCHEMA_READER_HELPER.loadTableFromTableNode(tableNode);
    }

    @Override
    public IContainer<TableDto> loadTables() {
        IContainer<IMutableNode<?>> tableNodes = DATABASE_NODE_SEARCHER.getStoredTableNodesFromNodeDatabase(this.nodeDatabase);
        return tableNodes.to(SCHEMA_READER_HELPER::loadTableFromTableNode);
    }

    @Override
    public void noteClose() {
    }
}

