/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.gui.cssmapper;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.web.cssmodel.CssProperty;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.system.gui.cssmapper.BackgroundToCssMapperHelper;
import ch.nolix.system.gui.cssmapper.CornerShadowToCssMapperHelper;
import ch.nolix.systemapi.gui.background.BackgroundType;
import ch.nolix.systemapi.gui.background.IBackground;
import ch.nolix.systemapi.gui.box.ICornerShadow;
import ch.nolix.systemapi.gui.cssmapper.ICssPropertyMapper;
import ch.nolix.systemapi.gui.font.LineDecoration;
import ch.nolix.systemapi.gui.location.Location;
import java.util.Optional;

public final class CssPropertyMapper
implements ICssPropertyMapper {
    @Override
    public IContainer<ICssProperty> mapBackgroundToCssProperties(IBackground background) {
        BackgroundType type = background.getType();
        return switch (type) {
            case BackgroundType.COLOR -> BackgroundToCssMapperHelper.mapBackgroundToCssPropertiesWhenIsColor(background);
            case BackgroundType.COLOR_GRADIENT -> BackgroundToCssMapperHelper.mapBackgroundToCssPropertiesWhenIsColorGradient(background);
            case BackgroundType.IMAGE -> BackgroundToCssMapperHelper.mapBackgroundToCssPropertiesWhenIsImage(background);
            case BackgroundType.TRANSPARENCY -> BackgroundToCssMapperHelper.TRANSPARENT_BACKGROUND_CSS_PROPERTIES;
            default -> throw InvalidArgumentException.forArgument((Object)type);
        };
    }

    @Override
    public ICssProperty mapCornerShadowToCssProperty(ICornerShadow cornerShadow) {
        return switch (cornerShadow.getLocation()) {
            case Location.OUTSIDE -> CornerShadowToCssMapperHelper.mapCornerShadowToCssPropertyWhenShadowIsOutsideTheBox(cornerShadow);
            case Location.INSIDE -> CornerShadowToCssMapperHelper.mapCornerShadowToCssPropertyWhenShadowIsInsideTheBox(cornerShadow);
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public Optional<ICssProperty> mapCornerShadowsToOptionalCssProperty(IContainer<? extends ICornerShadow> cornerShadows) {
        if (cornerShadows.containsAny()) {
            return Optional.of(CssProperty.withNameAndValue("box-shadow", cornerShadows.getViewOf(s -> this.mapCornerShadowToCssProperty((ICornerShadow)s).getValue()).toStringWithSeparator(",")));
        }
        return Optional.empty();
    }

    @Override
    public ICssProperty mapLineDecorationToCssProperty(LineDecoration lineDecoration) {
        return switch (lineDecoration) {
            case LineDecoration.UNDERLINE -> CssProperty.withNameAndValue("text-decoration-line", "underline");
            case LineDecoration.MIDLINE -> CssProperty.withNameAndValue("text-decoration-line", "line-through");
            case LineDecoration.OVERLINE -> CssProperty.withNameAndValue("text-decoration-line", "overline");
            default -> throw InvalidArgumentException.forArgument((Object)lineDecoration);
        };
    }
}

