/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.graphic.color;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.datastructure.pair.Pair;
import ch.nolix.core.reflection.reflectiontool.ReflectionTool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.datastructure.pair.IPair;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.systemapi.graphic.color.IColor;
import java.lang.reflect.Field;

public final class X11ColorCatalogExtractor {
    private static final String STRING_CONSTANT_POSTFIX = "_STRING";

    private X11ColorCatalogExtractor() {
    }

    public static IContainer<IPair<String, IColor>> getColorConstantsFromClass(Class<?> paramClass) {
        LinkedList<IPair<String, IColor>> x11Colors = LinkedList.createEmpty();
        ILinkedList<Field> colorStringFields = X11ColorCatalogExtractor.getColorNameConstantFields(paramClass);
        ILinkedList<Field> colorFields = X11ColorCatalogExtractor.getColorFields(paramClass);
        for (Field f : colorStringFields) {
            String colorStringFieldName = f.getName();
            Field colorField = colorFields.removeAndGetStoredFirst(cf -> colorStringFieldName.startsWith(cf.getName()));
            x11Colors.addAtEnd(new Pair<String, IColor>((String)ReflectionTool.getValueOfStaticField(f), (IColor)ReflectionTool.getValueOfStaticField(colorField)));
        }
        return x11Colors;
    }

    private static boolean declaresColor(Field field) {
        return ReflectionTool.isStatic(field) && ReflectionTool.canStoreValueOfTypeOrSuperType(field, Color.class);
    }

    private static boolean declaresColorName(Field field) {
        return ReflectionTool.isStatic(field) && field.getName().endsWith(STRING_CONSTANT_POSTFIX);
    }

    private static ILinkedList<Field> getColorFields(Class<?> paramClass) {
        LinkedList<Field> colorFields = LinkedList.createEmpty();
        Field[] fieldArray = paramClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (X11ColorCatalogExtractor.declaresColor(f)) {
                colorFields.addAtEnd(f);
            }
            ++n2;
        }
        return colorFields;
    }

    private static ILinkedList<Field> getColorNameConstantFields(Class<?> paramClass) {
        LinkedList<Field> colorNameConstantFields = LinkedList.createEmpty();
        Field[] fieldArray = paramClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (X11ColorCatalogExtractor.declaresColorName(f)) {
                colorNameConstantFields.addAtEnd(f);
            }
            ++n2;
        }
        return colorNameConstantFields;
    }
}

