/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.graphic.color;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnrepresentingArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datastructure.pair.IPair;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.graphic.color.X11ColorCatalogExtractor;
import ch.nolix.systemapi.graphic.color.IColor;
import java.util.Optional;

public final class Color
extends AbstractElement
implements IColor {
    public static final int DEFAULT_ALPHA_VALUE = 255;
    public static final long MIN_COLOR_LONG = 0L;
    public static final long MAX_COLOR_LONG = 0x100000000L;
    public static final short MIN_COLOR_COMPONENT = 0;
    public static final short MAX_COLOR_COMPONENT = 255;
    private static IContainer<IPair<String, IColor>> x11Colors;
    private final short memberRedValue;
    private final short memberGreenValue;
    private final short memberBlueValue;
    private final short memberAlphaValue;

    private Color(int redValue, int greenValue, int blueValue) {
        this(redValue, greenValue, blueValue, 255);
    }

    private Color(int redValue, int greenValue, int blueValue, int alphaValue) {
        Validator.assertThat(redValue).thatIsNamed("red value").isBetween(0, 255);
        Validator.assertThat(greenValue).thatIsNamed("green value").isBetween(0, 255);
        Validator.assertThat(blueValue).thatIsNamed("blue value").isBetween(0, 255);
        Validator.assertThat(blueValue).thatIsNamed("alpha value").isBetween(0, 255);
        this.memberRedValue = (short)redValue;
        this.memberGreenValue = (short)greenValue;
        this.memberBlueValue = (short)blueValue;
        this.memberAlphaValue = (short)alphaValue;
    }

    public static Color createAverageFrom(IColor color, IColor ... colors) {
        ContainerView<IColor> allColors = ContainerView.forElementAndArray(color, colors);
        return Color.createAverageFrom(allColors);
    }

    public static Color createAverageFrom(IContainer<IColor> colors) {
        int colorCount = colors.getCount();
        int averageRedValue = 0;
        int averageGreenValue = 0;
        int averageBlueValue = 0;
        int averateAlphaValue = 0;
        for (IColor c : colors) {
            averageRedValue += c.getRedValue();
            averageGreenValue += c.getGreenValue();
            averageBlueValue += c.getBlueValue();
            averateAlphaValue += c.getAlphaValue();
        }
        return new Color(averageRedValue / colorCount, averageGreenValue / colorCount, averageBlueValue / colorCount, averateAlphaValue / colorCount);
    }

    public static Color fromColor(IColor color) {
        if (color instanceof Color) {
            Color localColor = (Color)color;
            return localColor;
        }
        return Color.withRedValueAndGreenValueAndBlueValueAndAlphaValue(color.getRedValue(), color.getGreenValue(), color.getBlueValue(), color.getAlphaValue());
    }

    public static Color fromLong(long pLong) {
        Validator.assertThat(pLong).isBetween(0L, 0x100000000L);
        long lLong = pLong;
        int alphaValue = 255;
        if (lLong >= 0x1000000L) {
            alphaValue = (int)(lLong % 256L);
            lLong /= 256L;
        }
        int blueValue = (int)(lLong % 256L);
        int greenValue = (int)((lLong /= 256L) % 256L);
        int redValue = (int)(lLong /= 256L);
        return new Color(redValue, greenValue, blueValue, alphaValue);
    }

    public static Color fromSpecification(INode<?> specification) {
        return Color.fromString(specification.getSingleChildNodeHeader());
    }

    public static Color fromString(String string) {
        Optional<IPair> webColorAndName = Color.getX11Colors().getOptionalStoredFirst(p -> ((String)p.getStoredElement1()).equals(string));
        if (webColorAndName.isEmpty()) {
            if (!(string.length() == 8 && string.length() == 10 || string.substring(0, 2).equals("0x"))) {
                throw UnrepresentingArgumentException.forArgumentAndType(string, Color.class);
            }
            int redValue = Color.getColorComponentFrom(string.substring(2, 4));
            int greenValue = Color.getColorComponentFrom(string.substring(4, 6));
            int blueValue = Color.getColorComponentFrom(string.substring(6, 8));
            if (string.length() == 8) {
                return new Color(redValue, greenValue, blueValue);
            }
            int alphaValue = Color.getColorComponentFrom(string.substring(8, 10));
            return new Color(redValue, greenValue, blueValue, alphaValue);
        }
        return (Color)webColorAndName.get().getStoredElement2();
    }

    public static Color withRedValueAndGreenValueAndBlueValue(int redValue, int greenValue, int blueValue) {
        return new Color(redValue, greenValue, blueValue);
    }

    public static Color withRedValueAndGreenValueAndBlueValueAndAlphaValue(int redValue, int greenValue, int blueValue, int alphaValue) {
        return new Color(redValue, greenValue, blueValue, alphaValue);
    }

    private static int getColorComponentFrom(String string) {
        int value = 0;
        int base = 1;
        int i = string.length() - 1;
        while (i >= 0) {
            char hexadecimalDigit = string.charAt(i);
            int characterInt = Color.mapHexadecimalDigitFromStringToInt(hexadecimalDigit, string);
            value += characterInt * base;
            base *= 16;
            --i;
        }
        return value;
    }

    private static IContainer<IPair<String, IColor>> getX11Colors() {
        if (x11Colors == null) {
            x11Colors = X11ColorCatalogExtractor.getColorConstantsFromClass(X11ColorCatalog.class);
        }
        return x11Colors;
    }

    private static int mapHexadecimalDigitFromStringToInt(char hexadecimalDigit, String string) {
        return switch (hexadecimalDigit) {
            case '0' -> 0;
            case '1' -> 1;
            case '2' -> 2;
            case '3' -> 3;
            case '4' -> 4;
            case '5' -> 5;
            case '6' -> 6;
            case '7' -> 7;
            case '8' -> 8;
            case '9' -> 9;
            case 'A' -> 10;
            case 'B' -> 11;
            case 'C' -> 12;
            case 'D' -> 13;
            case 'E' -> 14;
            case 'F' -> 15;
            default -> throw InvalidArgumentException.forArgument(string);
        };
    }

    @Override
    public double getAlphaPercentage() {
        return (double)this.getAlphaValue() / 255.0;
    }

    @Override
    public int getAlphaValue() {
        return this.memberAlphaValue;
    }

    @Override
    public IContainer<INode<?>> getAttributes() {
        return LinkedList.withElement(Node.withHeader(this.toHexadecimalString()), new INode[0]);
    }

    @Override
    public double getBluePercentage() {
        return (double)this.getBlueValue() / 255.0;
    }

    @Override
    public int getBlueValue() {
        return this.memberBlueValue;
    }

    @Override
    public String getColorNameOrHexadecimalString() {
        Optional<IPair> webColorAndName = Color.getX11Colors().getOptionalStoredFirst(wc -> ((IColor)wc.getStoredElement2()).equals(this));
        if (webColorAndName.isPresent()) {
            return (String)webColorAndName.get().getStoredElement1();
        }
        return this.toHexadecimalString();
    }

    @Override
    public double getGreenPercentage() {
        return (double)this.getGreenValue() / 255.0;
    }

    @Override
    public int getGreenValue() {
        return this.memberGreenValue;
    }

    @Override
    public Color getInvertedColor() {
        return new Color(255 - this.memberRedValue, 255 - this.memberGreenValue, 255 - this.memberBlueValue, this.memberAlphaValue);
    }

    @Override
    public double getRedPercentage() {
        return (double)this.getRedValue() / 255.0;
    }

    @Override
    public int getRedValue() {
        return this.memberRedValue;
    }

    @Override
    public boolean hasFullAlphaValue() {
        return this.memberAlphaValue == 255;
    }

    @Override
    public boolean hasFullBlueValue() {
        return this.memberBlueValue == 255;
    }

    @Override
    public boolean hasFullGreenValue() {
        return this.memberGreenValue == 255;
    }

    @Override
    public boolean hasFullRedValue() {
        return this.memberRedValue == 255;
    }

    @Override
    public int toAlphaRedGreenBlueInt() {
        return this.getAlphaValue() << 24 | this.getRedValue() << 16 | this.getGreenValue() << 8 | this.getBlueValue();
    }

    @Override
    public String toHexadecimalString() {
        String string = "0x" + String.format("%02X", this.memberRedValue) + String.format("%02X", this.memberGreenValue) + String.format("%02X", this.memberBlueValue);
        if (!this.hasFullAlphaValue()) {
            string = string + String.format("%02X", this.memberAlphaValue);
        }
        return string;
    }

    @Override
    public String toHexadecimalStringWithAlphaValue() {
        return "0x" + String.format("%02X", this.memberRedValue) + String.format("%02X", this.memberGreenValue) + String.format("%02X", this.memberBlueValue) + String.format("%02X", this.memberAlphaValue);
    }

    @Override
    public long toLong() {
        if (!this.hasFullAlphaValue()) {
            return 0x1000000L * (long)this.getRedValue() + (long)(65536 * this.getGreenValue()) + (long)(256 * this.getBlueValue()) + (long)this.getAlphaValue();
        }
        return 65536L * (long)this.getRedValue() + (long)(256 * this.getGreenValue()) + (long)this.getBlueValue();
    }

    @Override
    public IColor withFloatingPointAlphaValue(double floatingPointAlphaValue) {
        Validator.assertThat(floatingPointAlphaValue).thatIsNamed("floating point number alpha value").isBetween(0.0, 1.0);
        return Color.withRedValueAndGreenValueAndBlueValueAndAlphaValue(this.memberRedValue, this.memberGreenValue, this.memberBlueValue, (int)(255.0 * floatingPointAlphaValue));
    }

    @Override
    public Color withFullAlphaValue() {
        return new Color(this.memberRedValue, this.memberGreenValue, this.memberBlueValue);
    }

    @Override
    public Color withAlphaValue(int alphaValue) {
        return Color.withRedValueAndGreenValueAndBlueValueAndAlphaValue(this.memberRedValue, this.memberGreenValue, this.memberBlueValue, alphaValue);
    }
}

