/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.relativevalue;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.systemapi.element.relativevalue.IAbsoluteOrRelativeInt;
import java.text.DecimalFormat;

public final class AbsoluteOrRelativeInt
extends AbstractElement
implements IAbsoluteOrRelativeInt {
    private final boolean isAbsolute;
    private final int absoluteValue;
    private final double percentage;

    private AbsoluteOrRelativeInt(int intValue) {
        this.isAbsolute = true;
        this.absoluteValue = intValue;
        this.percentage = 0.0;
    }

    private AbsoluteOrRelativeInt(double percentage) {
        Validator.assertThat(percentage).thatIsNamed("percentage").isNotNegative();
        this.isAbsolute = false;
        this.absoluteValue = 0;
        this.percentage = percentage;
    }

    public static AbsoluteOrRelativeInt fromSpecification(INode<?> specification) {
        String attribute = specification.getSingleChildNodeHeader();
        if (attribute.endsWith("%")) {
            return AbsoluteOrRelativeInt.withPercentage(0.01 * Double.valueOf(attribute.substring(0, attribute.length() - 1)));
        }
        return AbsoluteOrRelativeInt.withIntValue(Integer.parseInt(attribute));
    }

    public static AbsoluteOrRelativeInt withIntValue(int intValue) {
        return new AbsoluteOrRelativeInt(intValue);
    }

    public static AbsoluteOrRelativeInt withPercentage(double percentage) {
        return new AbsoluteOrRelativeInt(percentage);
    }

    @Override
    public IContainer<INode<?>> getAttributes() {
        LinkedList<INode<?>> attributes = LinkedList.createEmpty();
        if (this.isAbsolute()) {
            attributes.addAtEnd(Node.withHeader(this.getAbsoluteValue()));
        } else if (this.isRelative()) {
            attributes.addAtEnd(Node.withHeader(new DecimalFormat("0.#").format(100.0 * this.getPercentage()) + "%"));
        } else {
            throw InvalidArgumentException.forArgument(this);
        }
        return attributes;
    }

    @Override
    public int getAbsoluteValue() {
        this.assertIsAbsolute();
        return this.absoluteValue;
    }

    @Override
    public double getPercentage() {
        this.assertIsRelative();
        return this.percentage;
    }

    @Override
    public int getValueRelativeToHundredPercentValue(int hundredPercentValue) {
        if (this.isAbsolute) {
            return this.absoluteValue;
        }
        return (int)(this.percentage * (double)hundredPercentValue);
    }

    @Override
    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    @Override
    public boolean isPositive() {
        if (this.isAbsolute) {
            return this.absoluteValue > 0;
        }
        return this.percentage > 0.0;
    }

    @Override
    public boolean isRelative() {
        return !this.isAbsolute();
    }

    private void assertIsAbsolute() {
        if (!this.isAbsolute()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "absolute value");
        }
    }

    private void assertIsRelative() {
        if (!this.isRelative()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "percentage");
        }
    }
}

