/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.systemapi.element.property.IProperty;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class MutableOptionalValueExtractor<V>
implements IProperty,
INameHolder {
    private final String name;
    private final Consumer<V> setter;
    private final BooleanSupplier valuePresenceChecker;
    private final Supplier<V> getter;
    private final Function<INode<?>, V> valueCreator;
    private final Function<V, INode<?>> specificationCreator;

    public MutableOptionalValueExtractor(String name, Consumer<V> setter, BooleanSupplier valuePresenceChecker, Supplier<V> getter, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        Validator.assertThat(name).thatIsNamed("Name").isNotBlank();
        Validator.assertThat(setter).thatIsNamed("setter").isNotNull();
        Validator.assertThat(valuePresenceChecker).thatIsNamed("value presence checker").isNotNull();
        Validator.assertThat(getter).thatIsNamed("getter").isNotNull();
        Validator.assertThat(valueCreator).thatIsNamed("value creator").isNotNull();
        Validator.assertThat(specificationCreator).thatIsNamed("specification creator").isNotNull();
        this.name = name;
        this.setter = setter;
        this.valuePresenceChecker = valuePresenceChecker;
        this.getter = getter;
        this.valueCreator = valueCreator;
        this.specificationCreator = specificationCreator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean addedOrChangedAttribute(INode<?> attribute) {
        if (attribute.hasHeader(this.getName())) {
            this.setter.accept(this.valueCreator.apply(attribute));
            return true;
        }
        return false;
    }

    @Override
    public void fillUpAttributesInto(ILinkedList<INode<?>> list) {
        if (this.valuePresenceChecker.getAsBoolean()) {
            list.addAtEnd(this.specificationCreator.apply(this.getter.get()));
        }
    }
}

