/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.mutableelement;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.errormapping.IllegalAccessErrorMapper;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.SpecificationCreator;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.element.mutableelement.IMutableElement;
import ch.nolix.systemapi.element.property.IProperty;
import java.lang.reflect.Field;

public abstract class AbstractMutableElement
implements IMutableElement {
    private LinkedList<IProperty> properties;

    @Override
    public final void addOrChangeAttribute(INode<?> attribute) {
        for (IProperty p : this.getStoredProperties()) {
            if (!p.addedOrChangedAttribute(attribute)) continue;
            return;
        }
        throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "cannot not have a " + attribute.getHeader());
    }

    @Override
    public final void addOrChangeAttribute(String attribte, String ... attributes) {
        this.addOrChangeAttribute(Node.fromString(attribte));
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            this.addOrChangeAttribute(Node.fromString(a));
            ++n2;
        }
    }

    public final boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.hasSameSpecificationAs((IElement)object);
    }

    @Override
    public final IContainer<INode<?>> getAttributes() {
        LinkedList<INode<?>> attributes = LinkedList.createEmpty();
        for (IProperty p : this.getStoredProperties()) {
            p.fillUpAttributesInto(attributes);
        }
        return attributes;
    }

    @Override
    public final INode<?> getSpecification() {
        return SpecificationCreator.getSpecificationOfElement(this);
    }

    public final int hashCode() {
        return this.getSpecification().hashCode();
    }

    public final void resetFromFileWithFilePath(String filePath) {
        this.resetFromSpecification(Node.fromFile(filePath));
    }

    public final String toString() {
        return this.getSpecification().toString();
    }

    private void extractPotentialPropertyFrom(Field field) {
        if (IProperty.class.isAssignableFrom(field.getType())) {
            this.extractPropertyFrom(field);
        }
    }

    private void extractProperties() {
        this.properties = LinkedList.createEmpty();
        Class<?> lClass = this.getClass();
        while (lClass != null) {
            this.extractPropertiesFrom(lClass);
            lClass = lClass.getSuperclass();
        }
    }

    private void extractPropertiesFrom(Class<?> pClass) {
        Field[] fieldArray = pClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            this.extractPotentialPropertyFrom(f);
            ++n2;
        }
    }

    private void extractPropertiesIfNotExtracted() {
        if (!this.hasExtractedProperties()) {
            this.extractProperties();
        }
    }

    private void extractPropertyFrom(Field field) {
        try {
            field.setAccessible(true);
            IProperty property = (IProperty)field.get(this);
            Validator.assertThat(property).isOfType(IProperty.class);
            this.properties.addAtEnd(property);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw IllegalAccessErrorMapper.mapIllegalAccessExceptionToIllegalAccessError(illegalAccessException);
        }
    }

    private IContainer<IProperty> getStoredProperties() {
        this.extractPropertiesIfNotExtracted();
        return this.properties;
    }

    private boolean hasExtractedProperties() {
        return this.properties != null;
    }

    private boolean hasSameSpecificationAs(IElement element) {
        return this.getSpecification().equals(element.getSpecification());
    }
}

