/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.multistateconfiguration;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.multistateconfiguration.AbstractMaterializedProperty;
import ch.nolix.system.element.multistateconfiguration.State;
import ch.nolix.system.element.multistateconfiguration.StateProperty;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class NonCascadingProperty<S extends Enum<S>, V>
extends AbstractMaterializedProperty<S, V> {
    private final V defaultValue;

    public NonCascadingProperty(String name, Class<S> stateClass, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator, V defaultValue) {
        super(name, stateClass, valueCreator, specificationCreator);
        Validator.assertThat(defaultValue).thatIsNamed("default value").isNotNull();
        this.defaultValue = defaultValue;
    }

    public NonCascadingProperty(String name, Class<S> stateClass, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator, BiConsumer<S, V> setterMethod, V defaultValue) {
        super(name, stateClass, valueCreator, specificationCreator, setterMethod);
        Validator.assertThat(defaultValue).thatIsNamed("default value").isNotNull();
        this.defaultValue = defaultValue;
    }

    public static <S2 extends Enum<S2>> NonCascadingProperty<S2, Double> forDoubleWithNameAndStateClassAndSetterMethodAndDefaultValue(String name, Class<S2> stateClass, BiConsumer<S2, Double> setterMethod, double defaultValue) {
        return new NonCascadingProperty<S2, Double>(name, stateClass, INode::getSingleChildNodeAsDouble, Node::withChildNode, setterMethod, defaultValue);
    }

    public static <S2 extends Enum<S2>> NonCascadingProperty<S2, Integer> forIntWithNameAndStateClassAndSetterMethodAndDefaultValue(String name, Class<S2> stateClass, BiConsumer<S2, Integer> setterMethod, int defaultValue) {
        return new NonCascadingProperty<S2, Integer>(name, stateClass, INode::getSingleChildNodeAsInt, Node::withChildNode, setterMethod, defaultValue);
    }

    public void setEmptyForState(S state) {
        this.stateProperties[this.getStateOf(state).getIndex()].setEmpty();
    }

    @Override
    protected V getValueWhenHasState(State<S> state) {
        StateProperty stateProperty = this.stateProperties[state.getIndex()];
        if (stateProperty.hasValueOrDefinesEmpty()) {
            return stateProperty.getValue();
        }
        StateProperty baseStateProperty = this.getStoredBaseStateProperty();
        if (baseStateProperty.hasValueOrDefinesEmpty()) {
            return baseStateProperty.getValue();
        }
        return this.defaultValue;
    }

    @Override
    protected boolean hasValueWhenHasState(State<S> state) {
        StateProperty stateProperty = this.stateProperties[state.getIndex()];
        if (stateProperty.hasValueOrDefinesEmpty()) {
            return stateProperty.hasValue();
        }
        StateProperty baseStateProperty = this.getStoredBaseStateProperty();
        if (baseStateProperty.hasValueOrDefinesEmpty()) {
            return baseStateProperty.hasValue();
        }
        return false;
    }
}

